% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dist_wlatlng_cpp}
\alias{distRpl_wlatlng_cpp}
\alias{distSgl_wlatlng_cpp}
\alias{dist_wlatlng_cpp}
\alias{dist_wlatlng_km_cpp}
\alias{dist_wlatlng_mi_cpp}
\title{dist_wlatlng_cpp}
\usage{
dist_wlatlng_mi_cpp(lat1, lng1, lat2, lng2)

dist_wlatlng_km_cpp(lat1, lng1, lat2, lng2)

distSgl_wlatlng_cpp(lat1, lng1, lat2, lng2, measure = "mi")

distRpl_wlatlng_cpp(lat1, lng1, lat2, lng2, measure = "mi",
  distRpl_GS = 100L)
}
\arguments{
\item{lat1}{latitude of coordinate1}

\item{lng1}{longitude of coordinate1}

\item{lat2}{latitude of coordinate2}

\item{lng2}{longitude of coordinate2}

\item{measure}{"mi" (mile) or "km" (kilometer)}

\item{distRpl_GS}{The grain size of a parallel algorithm sets a minimum chunk size for parallelization.
In other words, at what point to stop processing input on separate threads (as sometimes creating more
threads can degrade the performance of an algorithm by introducing excessive synchronization overhead).
Default is 100.}
}
\description{
calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2>
}
\details{
calculate the great circle distance between 2 points with Haversine formula,
 which deliberately ignores elevation differences.

 Haversine formula (from R.W. Sinnott, "Virtues of the Haversine",
 Sky and Telescope, vol. 68, no. 2, 1984, p. 159):

 dlon = lon2 - lon1

 dlat = lat2 - lat1

 a = sin^2(dlat/2) + cos(lat1) * cos(lat2) * sin^2(dlon/2)

 c = 2 * arcsin(min(1,sqrt(a)))

 d = R * c

dist_wlatlng_mi_cpp:

  calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in mile

dist_wlatlng_km_cpp:

  calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in kilometer

distSgl_wlatlng_cpp:

  calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in
  mile (measure = "mi") or kilometer (measure = "km"), default is mile.

  implement as serial computing over vector of lat1, lng1, lat2, lng2

distRpl_wlatlng_cpp:

  calculate distance between coordinate1<lat1, lng1> and coordinate2<lat2, lng2> in
  mile (measure = "mi") or kilometer (measure = "km"), default is mile.

  implement as parallel computing over vector of lat1, lng1, lat2, lng2 via RcppParallel
}

