% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_sq.R
\name{eta_sq}
\alias{eta_sq}
\alias{omega_sq}
\alias{cohens_f}
\alias{anova_stats}
\title{Effect size statistics for anova}
\usage{
eta_sq(model, partial = FALSE)

omega_sq(model)

cohens_f(model)

anova_stats(model, digits = 3)
}
\arguments{
\item{model}{A fitted anova-model of class \code{aov} or \code{anova}. Other
models are coerced to \code{\link[stats]{anova}}.}

\item{partial}{Logical, if \code{TRUE}, the partial eta-squared is returned.}

\item{digits}{Number of decimal points in the returned data frame.}
}
\value{
A numeric vector with the effect size statistics; for \code{anova_stats()},
        a tidy data frame with all these statistics.
}
\description{
Returns the (partial) eta-squared, omega-squared statistic
             or Cohen's F for all terms in an anovas. \code{anova_stats()} returns
             a tidy summary, including all these statistics and power for each term.
}
\examples{
# load sample data
data(efc)

# fit linear model
fit <- aov(
  c12hour ~ as.factor(e42dep) + as.factor(c172code) + c160age,
  data = efc
)

eta_sq(fit)
omega_sq(fit)
eta_sq(fit, partial = TRUE)

anova_stats(car::Anova(fit, type = 2))

}
\references{
Levine TR, Hullett CR (2002): Eta Squared, Partial Eta Squared, and Misreporting of Effect Size in Communication Research (\href{https://www.msu.edu/~levinet/eta\%20squared\%20hcr.pdf}{pdf})
}
