% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model_labels.R
\name{get_term_labels}
\alias{get_term_labels}
\alias{get_dv_labels}
\title{Retrieve labels of model terms from regression models}
\usage{
get_term_labels(models, mark.cat = FALSE, case = NULL)

get_dv_labels(models, case = NULL)
}
\arguments{
\item{models}{One or more fitted regression models. May also be glm's or
mixed models. Any model with \code{\link[stats]{model.frame}} method
and which is supported by \pkg{broom}'s \code{\link[broom]{tidy}}
function should work.}

\item{mark.cat}{Logical, if \code{TRUE}, the returned vector has an
attribute with logical values, which indicate whether a label indicates
the value from a factor category (attribute value is \code{TRUE}) or
a term's variable labels (attribute value is \code{FALSE}).}

\item{case}{Desired target case. Labels will automatically converted into the
specified character case. See \code{\link[snakecase]{to_any_case}} for
more details on this argument.}
}
\value{
For \code{get_term_labels()}, a (named) character vector with
        variable labels of all model terms, which can be used, for instance,
        as axis labels to annotate plots. \cr \cr For \code{get_dv_labels()},
        a character vector with variable labels from all dependent variables
        of \code{models}.
}
\description{
This function retrieves variable labels from model terms. In case
       of categorical variables, where one variable has multiple dummies,
       variable name and category value is returned.
}
\details{
Typically, the variable labels from model terms are returned. However,
         for categorical terms that have estimates for each category, the
         value labels are returned as well. As the return value is a named
         vector, you can easily use it with \pkg{ggplot2}'s \code{scale_*()}
         functions to annotate plots.
}
\examples{
# use data set with labelled data
data(efc)

fit <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
get_term_labels(fit)

# make "education" categorical
library(sjmisc)
efc$c172code <- to_factor(efc$c172code)
fit <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
get_term_labels(fit)

# get label of dv
get_dv_labels(fit)

# create "labelled" plot
library(ggplot2)
library(broom)
ggplot(tidy(fit)[-1, ], aes(x = term, y = estimate)) +
  geom_point() +
  coord_flip() +
  scale_x_discrete(labels = get_term_labels(fit))

}
