% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{get_var_labels}
\alias{get_var_labels}
\title{Retrieve variable labels of (an SPSS-imported) data frame or of a specific variable}
\usage{
get_var_labels(x)
}
\arguments{
\item{x}{A data frame (containing imported SPSS data or with attached variable labels) or
         a vector with \code{"variable.label"} attribute.}
}
\value{
A named char vector with all variable labels from the SPSS dataset,
          or a simple string vector with the variable label, if \code{x} is a variable.
}
\description{
This function retrieves the variable labels of an imported
               SPSS data set (via \code{\link{read_spss}}) and
               \itemize{
                 \item if \code{x} is a data frame, returns the all variable labels as \code{\link{list}} object
                 \item or, if \code{x} is a vector, returns the variable label as string.
                 }
}
\note{
This function only works with vectors that have value and variable
       labels attached. This is automatically done by importing SPSS data sets
       with the \code{\link{read_spss}} function and can manually be applied
       with the \code{\link{set_val_labels}} and \code{\link{set_var_labels}}
       functions. \cr \cr
       With attached value and variable labels, most functions of this package
       automatically detect labels and uses them as axis, legend or title labels
       in plots (\code{sjp.}-functions) respectively as column or row headers
       in table outputs (\code{sjt.}-functions). Use \code{options(autoSetValueLabels = FALSE)}
       and \code{options(autoSetVariableLabels = FALSE)} to turn off automatic
       label detection.
}
\examples{
# import SPSS data set
# mydat <- read_spss("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- get_var_labels(mydat)

# retrieve value labels
# mydat.val <- get_val_labels(mydat)

data(efc)
# sample data set has not attached variable labels to each vector
# so we have to do this first... use 'autoAttachVarLabels' in
# function 'read_spss' to automatically perform this step.
efc <- set_var_labels(efc, get_var_labels(efc))

# get variable lable
get_var_labels(efc$e42dep)

# alternative way
get_var_labels(efc)["e42dep"]
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{read_spss}}
           \item \code{\link{write_spss}}
           \item \code{\link{to_label}}
           \item \code{\link{to_value}}
           \item \code{\link{set_var_labels}}
           \item \code{\link{set_val_labels}}
           \item \code{\link{get_val_labels}}
           }
}

