% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_geo_dist.R
\name{sits_geo_dist}
\alias{sits_geo_dist}
\title{Compute the minimum distances among samples and prediction points.}
\usage{
sits_geo_dist(samples, roi, n = 1000, crs = "EPSG:4326")
}
\arguments{
\item{samples}{A \code{samples} training data set.}

\item{roi}{A region of interest (ROI) used to extract random
predicted points.}

\item{n}{Maximum number of samples to consider.}

\item{crs}{CRS of the \code{samples}.}
}
\value{
A tibble with sample-to-sample and sample-to-prediction distances.
}
\description{
Compute the minimum distances among samples and samples to prediction
points, following the approach proposed by Meyer and Pebesma(2022).
}
\examples{
if (sits_run_examples()) {
    # read a shapefile for the state of Mato Grosso, Brazil
    mt_shp <- system.file("extdata/shapefiles/mato_grosso/mt.shp",
        package = "sits"
    )
    # convert to an sf object
    mt_sf <- sf::read_sf(mt_shp)
    # calculate sample-to-sample and sample-to-prediction distances
    distances <- sits_geo_dist(samples = samples_modis_ndvi,
    roi = mt_sf)
    # plot sample-to-sample and sample-to-prediction distances
    plot(distances)
}
}
\references{
Meyer, H., Pebesma, E. "Machine learning-based global maps of
ecological variables and the challenge of assessing them",
Nature Communications 13, 2208 (2022).
https://doi.org/10.1038/s41467-022-29838-9
}
\author{
Alber Sanchez, \email{alber.ipia@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
