% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_sf.R
\name{sits_as_sf}
\alias{sits_as_sf}
\alias{sits_as_sf.sits}
\alias{sits_as_sf.raster_cube}
\title{Return a sits_tibble or raster_cube as an sf object.}
\usage{
sits_as_sf(data, ..., as_crs = NULL)

\method{sits_as_sf}{sits}(data, ..., crs = "EPSG:4326", as_crs = NULL)

\method{sits_as_sf}{raster_cube}(data, ..., as_crs = NULL)
}
\arguments{
\item{data}{A sits tibble or sits cube.}

\item{...}{Additional parameters.}

\item{as_crs}{Output coordinate reference system.}

\item{crs}{Input coordinate reference system.}
}
\value{
An sf object of point or polygon geometry.
}
\description{
Return a sits_tibble or raster_cube as an sf object.
}
\examples{
if (sits_run_examples()) {
   # convert sits tibble to an sf object (point)
   sf_object <- sits_as_sf(cerrado_2classes)

   # convert sits cube to an sf object (polygon)
   data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
   cube <- sits_cube(
       source = "BDC",
       collection = "MOD13Q1-6",
       data_dir = data_dir,
       delim = "_",
       parse_info = c("X1", "tile", "band", "date")
   )
   sf_object <- sits_as_sf(cube)
}
}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
