% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{set_capacity}
\alias{set_capacity}
\alias{set_capacity_selected}
\alias{set_queue_size}
\alias{set_queue_size_selected}
\title{Set Resource Parameters}
\usage{
set_capacity(.trj, resource, value, mod = c(NA, "+", "*"))

set_capacity_selected(.trj, value, id = 0, mod = c(NA, "+", "*"))

set_queue_size(.trj, resource, value, mod = c(NA, "+", "*"))

set_queue_size_selected(.trj, value, id = 0, mod = c(NA, "+", "*"))
}
\arguments{
\item{.trj}{the trajectory object.}

\item{resource}{the name of the resource.}

\item{value}{new value to set.}

\item{mod}{if set, \code{values} modify the attributes rather than substituting them.}

\item{id}{selection identifier for nested usage.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for dynamically modifying a resource's server capacity or queue
size, by name or a previously selected one. Resources must be defined in the
simulation environment (see \code{\link{add_resource}}).
}
\examples{
## a resource with a queue size equal to the number of arrivals waiting
traj <- trajectory() \%>\%
  set_queue_size("res", 1, mod="+") \%>\%
  seize("res") \%>\%
  set_queue_size("res", -1, mod="+") \%>\%
  timeout(10) \%>\%
  release("res")

simmer() \%>\%
  add_resource("res", 1, 0) \%>\%
  add_generator("dummy", traj, at(0:2)) \%>\%
  run() \%>\%
  get_mon_resources()

}
\seealso{
\code{\link{select}}, \code{\link{seize}}, \code{\link{release}},
\code{\link{seize_selected}}, \code{\link{release_selected}},
\code{\link{get_capacity}}, \code{\link{get_queue_size}}
}
