% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Text}
\alias{f7Text}
\title{Create an f7 text input}
\usage{
f7Text(inputId, label, value = "", placeholder = NULL)
}
\arguments{
\item{inputId}{Text input id.}

\item{label}{Text input label.}

\item{value}{Text input value.}

\item{placeholder}{Text input placeholder.}
}
\description{
Create an f7 text input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7Text"),
      f7Text(
       inputId = "caption",
       label = "Caption",
       value = "Data Summary",
       placeholder = "Your text here"
      ),
      verbatimTextOutput("value")
     )
   ),
   server = function(input, output) {
     output$value <- renderPrint({ input$caption })
   }
 )
}
}
