% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTTB_aggregator.R
\docType{class}
\name{LTTB_aggregator}
\alias{LTTB_aggregator}
\title{Aggregation using Largest Triangle Three Buckets (LTTB) method.}
\format{
An \code{R6::R6Class} object
}
\description{
The LTTB method aggregates the huge samples using the areas
of the triangles formed by the samples.
Numerical distances are employed in this class,
which requires the ratio between x and y values.
When the x is datetime, nanosecond is a unit.
When the x is factor or character, it will be encoded into numeric codes.
}
\examples{
data(noise_fluct)
agg <- LTTB_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(
  x = noise_fluct$time, y = noise_fluct$f500, n_out = 1000
  )
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")
}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{LTTB_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LTTB_aggregator-new}{\code{LTTB_aggregator$new()}}
\item \href{#method-LTTB_aggregator-clone}{\code{LTTB_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LTTB_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-LTTB_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LTTB_aggregator$new(
  ...,
  nt_y_ratio = 1e+09,
  x_y_ratio = 1,
  interleave_gaps,
  coef_gap,
  NA_position,
  accepted_datatype = c("numeric", "integer", "character", "factor", "logical")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_y_ratio, nt_y_ratio}}{Numeric.
These parameters set the unit length of the numeric \code{x}
and \code{nanotime} x.
For example, setting \code{x_y_ratio} to 2 is equivalent to
assuming 2 is the unit length of \code{x}
(and 1 is always the unit length of \code{y}).
The unit length is employed to calculate the area of the triangles.}

\item{\code{interleave_gaps, coef_gap, NA_position, accepted_datatype, ...}}{Arguments pass to the constructor of \code{aggregator} object.
Note that \code{accepted_datatype} has default value.
Downsample with the Largest Triangle Three Buckets (LTTB) aggregation method}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LTTB_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LTTB_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LTTB_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
