% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textArea.R
\name{textArea}
\alias{textArea}
\alias{updateTextArea}
\title{Text area component}
\usage{
textArea(
  inputId,
  value,
  label,
  width = "100\%",
  height = "200px",
  resize = "default",
  readonly = FALSE,
  ...
)

updateTextArea(session, inputId, value = NULL)
}
\arguments{
\item{inputId}{Id of component. This is stored as `data-id` attribute to omit automatic binding
of the element (into textAreaInput).}

\item{value}{Initial text area value or value to be updated.}

\item{label}{Text area label.}

\item{width}{Width of input area.}

\item{height}{Height of input area.}

\item{resize}{Text are directions where input field can be resized.
Possible options are "default", "both", "none", "vertical" and "horizontal".}

\item{readonly}{If TRUE, providing custom values will be turned off.}

\item{...}{Extra arguments passed to \code{textarea} tag form \link[shiny]{tags}.}

\item{session}{Shiny session object.}
}
\value{
Nested list of `shiny.tag` objects defining html structure of the component,
  or no value in case of usage of `updateTextArea` method.
}
\description{
Contrary to \link[shiny]{textAreaInput} the component is not a binding itself
(doesn't send input to the server).
Thanks to that, the component can store much more text value without slowing
down the application.

If you want to access the component value on request please use \link{valueButton}.
}
