% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationDefinitions.R
\docType{class}
\name{MutationDefinition-class}
\alias{MutationDefinition-class}
\alias{MutationDefinition}
\title{S4 class defining replacement and silent mutation definitions}
\description{
\code{MutationDefinition} defines a common data structure for defining the whether
a mutation is annotated as a replacement or silent mutation.
}
\section{Slots}{

\describe{
\item{\code{name}}{name of the MutationDefinition.}

\item{\code{description}}{description of the model and its source.}

\item{\code{classes}}{named character vectors with single-letter amino acid codes as names
and amino acid classes as values, with \code{NA} assigned to set of 
characters \code{c("X", "*", "-", ".")}. Replacement (R) is be 
defined as a change in amino acid class and silent (S) as no 
change in class.}

\item{\code{codonTable}}{matrix of codons (columns) and substitutions (rows).}

\item{\code{citation}}{publication source.}
}}

\seealso{
See \link{MUTATION_SCHEMES} for a set of predefined \code{MutationDefinition} objects.
}
