% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{createSubstitutionMatrix}
\alias{createSubstitutionMatrix}
\title{Builds a substitution model}
\usage{
createSubstitutionMatrix(db, model = c("RS", "S"),
  sequenceColumn = "SEQUENCE_IMGT", germlineColumn = "GERMLINE_IMGT_D_MASK",
  vCallColumn = "V_CALL", multipleMutation = c("independent", "ignore"),
  returnModel = c("5mer", "1mer", "1mer_raw"), minNumMutations = 50)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{model}{type of model to create. The default model, "RS", creates 
a model by counting both replacement and silent mutations.
The "S" specification builds a model by counting only 
silent mutations.}

\item{sequenceColumn}{name of the column containing IMGT-gapped sample sequences.}

\item{germlineColumn}{name of the column containing IMGT-gapped germline sequences.}

\item{vCallColumn}{name of the column containing the V-segment allele call.}

\item{multipleMutation}{string specifying how to handle multiple mutations occuring 
within the same 5-mer. If \code{"independent"} then multiple 
mutations within the same 5-mer are counted indepedently. 
If \code{"ignore"} then 5-mers with multiple mutations are 
excluded from the total mutation tally.}

\item{returnModel}{string specifying what type of model to return; one of
\code{c("5mer", "1mer", "1mer_raw")}. If \code{"5mer"} 
(the default) then a 5-mer nucleotide context model is 
returned. If \code{"1mer"} or \code{"1mer_raw"} then a single 
nucleotide substitution matrix (no context) is returned;
where \code{"1mer_raw"} is the unnormalized version of the 
\code{"1mer"} model. Note, neither 1-mer model may be used
as input to \link{createMutabilityMatrix}.}

\item{minNumMutations}{minimum number of mutations required to compute the 5-mer 
substitution rates. If the number of mutations for a 5-mer
is below this threshold, its substitution rates will be 
estimated from neighboring 5-mers. Default is 50.}
}
\value{
A 4x1024 matrix of column normalized substitution rates for each 5-mer motif with 
          row names defining the center nucleotide, one of \code{c("A", "C", "G", "T")}, 
          and column names defining the 5-mer nucleotide sequence.
}
\description{
\code{createSubstitutionMatrix} builds a 5-mer nucleotide substitution model by counting 
the number of substitution mutations occuring in the center position for all 5-mer 
motifs.
}
\examples{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgA" & SAMPLE == "-1h")

# Create model using only silent mutations
sub <- createSubstitutionMatrix(db, model="S")

}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based 
           on synonymous mutations from high-throughput immunoglobulin sequencing data. 
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
\link{extendSubstitutionMatrix}, \link{createMutabilityMatrix}, 
          \link{createTargetingMatrix}, \link{createTargetingModel}
}

