% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_SSURGO_hydro_data.R
\name{prepare_SSURGO_hydro_data}
\alias{prepare_SSURGO_hydro_data}
\title{Get and prepare basic soil hydraulic parameters from SSURGO via SDA}
\usage{
prepare_SSURGO_hydro_data(cokeys, max.depth)
}
\arguments{
\item{cokeys}{vector of component keys (cokey) in current SSURGO snapshot}

\item{max.depth}{target depth of aggregation (cm), corrected later by real soil depth as reported by \code{slab()}}
}
\value{
a \code{list} containing:
\itemize{
\item \code{SPC}: \code{SoilProfileCollection}
\item \code{agg}: aggregate representation of hydraulic parameters, by cokey
}

The following soil hydraulic properties are included:\tabular{ll}{
   variable \tab description \cr
   cokey \tab component key \cr
   hzname \tab horizon name \cr
   hz_top \tab horizon top depth (cm) \cr
   hz_bottom \tab horizon bottom depth (cm) \cr
   thick \tab horizon thickness (cm) \cr
   sat \tab VWC at saturation (cm/cm) \cr
   fc \tab VWC at field capacity or 1/3rd bar tension (cm/cm) \cr
   pwp \tab VWC at permanent wilting point or 15 bar tension (cm/cm) \cr
   awc \tab total sand content (<2mm fraction, mass \%) \cr
   sand \tab total silt content (<2mm fraction, mass \%) \cr
   silt \tab total clay content (<2mm fraction, mass \%) \cr
   clay \tab total sand content (<2mm fraction, mass \%) \cr
   dbthirdbar \tab bulk density at 1/3 bar tension (g/cm^3) \cr
   ksat \tab Ksat (um/second) \cr
   soil_fraction \tab volume fraction of soil (1 - coarse fragment volume fraction) \cr
}
}
\description{
Get and prepare basic soil hydraulic parameters from SSURGO via SDA
}
\details{
Weighted mean soil hydraulic parameters are returned over the interval of \code{0-max.depth}, calculated by \code{aqp::slab()}.
}
\author{
D.E. Beaudette
}
