% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSoilRelationChordGraph.R
\name{plotSoilRelationChordGraph}
\alias{plotSoilRelationChordGraph}
\title{Visualize Soil Relationships via Chord Diagram}
\usage{
plotSoilRelationChordGraph(
  m,
  s,
  mult = 2,
  base.color = "grey",
  highlight.colors = c("RoyalBlue", "DarkOrange", "DarkGreen"),
  add.legend = TRUE,
  ...
)
}
\arguments{
\item{m}{an adjacency matrix, no \code{NA} allowed}

\item{s}{soil of interest, must exist in the column or row names of \code{m}}

\item{mult}{multiplier used to re-scale data in \code{m} associated with \code{s}}

\item{base.color}{color for all soils other than \code{s} and 1st and 2nd most commonly co-occurring soils}

\item{highlight.colors}{vector of 3 colors: soil of interest, 1st most common, 2nd most common}

\item{add.legend}{\code{logical}, add a legend}

\item{...}{additional arguments passed to \code{circlize::chordDiagramFromMatrix}}
}
\value{
nothing, function is called to generate graphical output
}
\description{
Visualize Soil Relationships via Chord Diagram
}
\details{
This function is experimental. Documentation pending. See \url{http://jokergoo.github.io/circlize/} for ideas.
}
\author{
D.E. Beaudette
}
\keyword{hplots}
