% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_c_test}
\alias{global_c_test}
\title{Global C Test}
\usage{
global_c_test(x, nb, wt, randomization = TRUE, allow_zero = NULL, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{randomization}{default \code{TRUE}. Calculate variance based on randomization. If \code{FALSE}, under the assumption of normality.}

\item{allow_zero}{If \code{TRUE}, assigns zero as lagged value to zone without neighbors.}

\item{...}{additional arguments passed to \code{\link[spdep:moran.mc]{spdep::moran.mc()}}}
}
\value{
an \code{htest} object
}
\description{
Global C Test
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
wt <- st_weights(nb)
x <- guerry$crime_pers
global_c_test(x, nb, wt)
}
\seealso{
Other global_c: 
\code{\link{global_c}()},
\code{\link{global_c_perm}()}
}
\concept{global_c}
