% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testConditionalSet}
\alias{testConditionalSet}
\alias{checkConditionalSet}
\alias{assertConditionalSet}
\title{assert/check/test/ConditionalSet}
\usage{
testConditionalSet(
  object,
  errormsg = "This is not an R6 ConditionalSet object"
)

checkConditionalSet(
  object,
  errormsg = "This is not an R6 ConditionalSet object"
)

assertConditionalSet(
  object,
  errormsg = "This is not an R6 ConditionalSet object"
)
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{ConditionalSet}.
}
\examples{
testConditionalSet(Set$new(2, 3))
testConditionalSet(list(Set$new(2), Set$new(3)))
testConditionalSet(Tuple$new(2, 3))
testConditionalSet(Interval$new())
testConditionalSet(FuzzySet$new(2, 0.1))
testConditionalSet(FuzzyTuple$new(2, 0.1))
testConditionalSet(ConditionalSet$new(function(x) x == 0))
}
