% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.hmm.R
\name{logLik.hmm}
\alias{logLik.hmm}
\title{Log-likelihood of the Hidden Markov Model}
\usage{
\method{logLik}{hmm}(object, partials = FALSE, threads = 1,
  log_space = FALSE, ...)
}
\arguments{
\item{object}{A  hidden Markov model of class \code{hmm}.}

\item{partials}{Return a vector containing the individual contributions of each sequence to the total log-likelihood. 
The default is \code{FALSE}, which returns the sum of all log-likelihood components.}

\item{threads}{Number of threads to use in parallel computing. The default is 1.}

\item{log_space}{Make computations using log-space instead of scaling for greater 
numerical stability at the cost of decreased computational performance. 
  The default is \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
Log-likelihood of the hidden Markov model. This is an object of class 
\code{logLik} with attributes \code{nobs} and \code{df} inherited from the model object.
}
\description{
Function \code{logLik.hmm} computes the log-likelihood value of a hidden Markov model.
}
\seealso{
\code{\link{build_hmm}} and \code{\link{fit_model}} for building and 
  fitting Hidden Markov models.
}
