% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_nse.R
\name{filter_nse}
\alias{filter_nse}
\title{Filter non-standard interface.}
\usage{
filter_nse(.data, ..., filter_nse_env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{...}{stringified expressions to filter by.}

\item{filter_nse_env}{environment to work in.}
}
\value{
.data filtered by columns named in filterTerms
}
\description{
Filter a data frame by the filter terms in \code{...}.
}
\examples{

upperBound <- 3.5

datasets::iris \%.>\%
  filter_nse(., Sepal.Length >= 2 * Sepal.Width,
                  Petal.Length <= upperBound)

}
\seealso{
\code{\link{filter_se}}, \code{\link[dplyr]{filter}}, \code{\link[dplyr]{filter_at}}
}
