% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_download.R
\name{s2_download}
\alias{s2_download}
\title{Download S2 products.}
\usage{
s2_download(s2_prodlist = NULL, downloader = "builtin", apihub = NA,
  tile = NULL, outdir = ".", overwrite = FALSE)
}
\arguments{
\item{s2_prodlist}{List of the products to be downloaded
(this must be the output of \link{s2_list} function).}

\item{downloader}{Executable to use to download products
(default: "builtin"). Alternatives are "builtin" or "aria2"
(this requires aria2c to be installed).}

\item{apihub}{Path of the "apihub.txt" file containing credentials
of SciHub account.
If NA (default), the default location inside the package will be used.}

\item{tile}{Single Sentinel-2 Tile string (5-length character)}

\item{outdir}{(optional) Full name of the existing output directory
where the files should be created (default: current directory).}

\item{overwrite}{Logical value: should existing output archives be
overwritten? (default: FALSE)}
}
\value{
NULL (the function is called for its side effects)
}
\description{
The function downloads a single S2 product.
Input filename must be an element obtained with
\link{s2_list} function
(the content must be a URL, and the name the product name).
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
single_s2 <- paste0("https://scihub.copernicus.eu/apihub/odata/v1/",
  "Products(\\'c7142722-42bf-4f93-b8c5-59fd1792c430\\')/$value")
names(single_s2) <- "S2A_MSIL1C_20170613T101031_N0205_R022_T32TQQ_20170613T101608.SAFE"
# (this is equivalent to:
# single_s2 <- example_s2_list[1]
# where example_s2_list is the output of the example of the
# s2_list() function)

# Download the whole product
s2_download(single_s2, outdir=tempdir())

#' # Download the whole product - using aria2
s2_download(single_s2, outdir=tempdir(), downloader = "aria2")

# Download a specific tile
s2_download(single_s2, tile="32TQQ", outdir=tempdir())
# (for products with compact names, the two above commands produce equivalent
# results: the first one downloads a SAFE archive, while the second one
# downloads single product files)

# Download a serie of products
pos <- st_sfc(st_point(c(12.0, 44.8)), crs=st_crs(4326))
time_window <- as.Date(c("2017-05-01","2017-07-30"))
example_s2_list <- s2_list(spatial_extent=pos, tile="32TQQ", time_interval=time_window)
s2_download(example_s2_list, outdir=tempdir())
}
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}

Lorenzo Busetto, phD (2019) \email{lbusett@gmail.com}
}
