% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_std_solution_boot.R
\name{print.std_solution_boot}
\alias{print.std_solution_boot}
\title{Print an 'std_solution_boot' Object}
\usage{
\method{print}{std_solution_boot}(x, ..., nd = 3, output = c("table", "text"), standardized_only = TRUE)
}
\arguments{
\item{x}{Object of the class
\code{std_solution_boot}.}

\item{...}{Optional arguments to be
passed to \code{\link[=print]{print()}} methods.}

\item{nd}{The number of digits
after the decimal place. Default
is 3.}

\item{output}{String. How the results
are printed. Default is \code{"table"} and
the results are printed in a table
format similar to that of
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.
If \code{"text"}, the results will be
printed in a text format similar to
the printout of the output of
\code{\link[=summary]{summary()}} of
a \linkS4class{lavaan} object.}

\item{standardized_only}{Logical.
If \code{TRUE}, the default, only the
results for the standardized solution
will be printed. If \code{FALSE}, then
the standardized solution is printed
alongside the unstandardized solution,
as in the printout of the output
of \code{\link[=summary]{summary()}} of a \linkS4class{lavaan}
object.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print method for an
'std_solution_boot' object, which
is the output of
\code{\link[=standardizedSolution_boot_ci]{standardizedSolution_boot_ci()}}.
}
\details{
The default format of the printout
is that of \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
which is compact but not easy to
read. Users can request a format
similar to that of the printout
of the summary of a \code{lavaan} output
by setting \code{output} to \code{"text"}.

For the \code{"text"} format, users can
also select whether
only the standardized solution is
printed (the default) or whether
the standardized solution is appended
to the right of the printout.
}
\examples{
library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

# Should set bootstrap to at least 2000 in real studies
fit <- sem(model, data = dat, fixed.x = FALSE,
           se = "boot",
           bootstrap = 50)
std_out <- standardizedSolution_boot_ci(fit)
std_out
print(std_out, output = "text")
print(std_out, output = "text", standardized_only = FALSE)

}
\seealso{
\code{\link[=standardizedSolution_boot_ci]{standardizedSolution_boot_ci()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
