% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{general_functions}
\alias{general_functions}
\alias{sm_area}
\alias{sm_centroid}
\alias{sm_intersection}
\alias{sm_subset_union}
\alias{sm_rbind}
\title{General functions}
\usage{
sm_area(s, order = NULL)

sm_centroid(s)

sm_intersection(s1, s2, touches = TRUE)

sm_subset_union(s)

sm_rbind(...)
}
\arguments{
\item{s, s1, s2}{Either a \code{ref_sf}, a \code{seg_sf}, or a \code{subset_sf} object
(inherited from \code{sf}).}

\item{order}{A \code{subset_sf}. This argument arranges the returned values
according to the object passed here.}

\item{touches}{A \code{logical}. Is the border part of the intersection?}

\item{...}{For \code{sm_rbind()}, a set of \code{subset_sf} objects to be
merged.}
}
\value{
\itemize{
\item \code{sm_area()}: Return a \code{numeric} vector with polygons' area.
\item \code{sm_centroid()}: Return a \code{subset_sf} object with polygons' centroid.
\item \code{sm_intersection()}: Return a \code{subset_sf} object with intersection
between polygons.
\item \code{sm_subset_union()}: Return a \code{subset_sf} object with union
between intersecting polygons.
\item \code{sm_rbind()}: Return a \code{subset_sf} object with unique features.
}
}
\description{
These functions manipulate segmetric objects.
\itemize{
\item \code{sm_area()}: Return a vector of areas, one for each polygon.
\item \code{sm_centroid()}: Return the centroids of the given polygons.
\item \code{sm_intersection()}: Return the intersection of the given simple features.
\item \code{sm_subset_union()}: Return the union of the given simple features.
\item \code{sm_rbind()}: Return the merge of unique simple features.
}
}
