% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse-map-seq.R
\name{reverse_map_seq}
\alias{reverse_map_seq}
\title{Reverse the \verb{*_map_seq()} process}
\usage{
reverse_map_seq(data)
}
\arguments{
\item{data}{Data frame that inherits the \code{"scr_map_seq"} class.}
}
\value{
The reconstructed tibble (data frame) which a factory-made
\verb{*_map_seq()} function took as its \code{data} argument.
}
\description{
\code{reverse_map_seq()} takes the output of a function created by
\code{\link[=function_map_seq]{function_map_seq()}} and reconstructs the original data frame.

See \code{\link[=audit_seq]{audit_seq()}}, which takes \code{reverse_map_seq()} as a basis.
}
\examples{
# Originally reported summary data...
pigs1

# ...GRIM-tested with varying inputs...
out <- grim_map_seq(pigs1, include_consistent = TRUE)

# ...and faithfully reconstructed:
reverse_map_seq(out)
}
