% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_ps2.r
\name{plot_double_param_scan_data}
\alias{plot_double_param_scan_data}
\title{Plot model double parameter scan time courses.}
\usage{
plot_double_param_scan_data(model, scanned_par1, scanned_par2, inputdir,
  outputdir, run)
}
\arguments{
\item{model}{the model name without extension}

\item{scanned_par1}{the 1st scanned parameter}

\item{scanned_par2}{the 2nd scanned parameter}

\item{inputdir}{the input directory}

\item{outputdir}{the output directory}

\item{run}{the simulation run}
}
\description{
Plot model double parameter scan time courses.
}
\examples{
data(insulin_receptor_ps2_tp2)
dir.create(file.path("ps2_datasets"))
write.table(insulin_receptor_ps2_tp2, 
            file=file.path("ps2_datasets", 
                           "insulin_receptor_InsulinPercent__IRbetaPercent__rep_1__tp_2.csv"), 
            row.names=FALSE)
plot_double_param_scan_data(model="insulin_receptor_InsulinPercent__IRbetaPercent", 
                            scanned_par1="InsulinPercent", 
                            scanned_par2="IRbetaPercent", 
                            inputdir="ps2_datasets", 
                            outputdir="ps2_plots", 
                            run=1)
}
