% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setColoursGrainType.R
\name{setColoursGrainType}
\alias{setColoursGrainType}
\title{Set colour scale for grain types}
\usage{
setColoursGrainType(ScaleName)
}
\arguments{
\item{ScaleName}{Name of graintype colour scale
\itemize{
\item \verb{iacs:} scale defined by the \emph{International Classification of Seasonal Snow on the Ground}
\item \verb{iacs2:} scale defined by the \emph{International Classification of Seasonal Snow on the Ground} with a dark red colour for MFcr layers so that MF and MFcr layers can be better distinguished.
\item \verb{sarp:} hazard adjusted colours for grain types based on Horton et al. (2020)
\item \verb{sarp-reduced:} hazard adjusted colours for groups of grain types based on Horton et al. (2020)
}}
}
\value{
data.frame containing the new colour values stored in \code{grainDict}
}
\description{
Currently, you can choose between 'iacs', 'iacs2', 'sarp', or 'sarp-reduced'.
}
\examples{

## Current/default grain type colours
grainDict
plot(SPpairs$A_manual, main = 'Snow profile with default colours')

## Change to IACS colours
grainDict <- setColoursGrainType('IACS')
grainDict
plot(SPpairs$A_manual, main = 'Snow profile with IACS colours')

## Change to IACS colours with adjusted MFcr (darkred)
grainDict <- setColoursGrainType('IACS2')
grainDict
plot(SPpairs$A_manual, main = 'Snow profile with IACS colours and adjusted darkred MFcr')

## Change to SARP colours
grainDict <- setColoursGrainType('SARP')
grainDict
plot(SPpairs$A_manual, main = 'Snow profile with SARP colours')

## Change to reduced SARP colours
grainDict <- setColoursGrainType('SARP-reduced')
grainDict
plot(SPpairs$A_manual, main = 'Snow profile with a reduced set of SARP colours')

}
\references{
Horton, S., Nowak, S., and Haegeli, P.: Enhancing the operational value of snowpack models with visualization design principles,
Nat. Hazards Earth Syst. Sci., 20, 1557–1572, \href{https://doi.org/10.5194/nhess-20-1557-2020}{https://doi.org/10.5194/nhess-20-1557-2020}, 2020.
}
\seealso{
\link{grainDict}, \link{getColoursGrainType}
}
