% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertdump.R
\name{dump}
\alias{dump}
\alias{dump_init}
\alias{dump_links}
\alias{dump_tbl}
\title{Use Vertnet taxon specific dump from KNB}
\usage{
dump_init(path, group = "amphibians", table = NULL)

dump_tbl(x)

dump_links()
}
\arguments{
\item{path}{(character) Path to a sqlite file on your machine.}

\item{group}{(character) One of mammals, reptiles, amphibians, fishes, or birds}

\item{table}{(character) sqlite table name, you can use anything you like, but
code defaults to the values in the \code{group} parameter}

\item{x}{An object of class \code{src_sqlite}}
}
\description{
Use Vertnet taxon specific dump from KNB
}
\details{
\code{dump_init} creates a \code{src_sqlite} class that you can use to
query the data either using SQL syntax or dplyr's R syntax. \code{dump_tbl} is
just a wrapper around \code{\link[dplyr]{tbl}} to create a \code{tbl} class
object that you can use to feed directly into dplyr's verbs, like
\code{\link[dplyr]{select}} and \code{\link[dplyr]{filter}}
}
\examples{
\dontrun{
# You first need to create your SQLite databases, e.g, for amphibians:
## In the terminal
# wget 
# https://knb.ecoinformatics.org/knb/d1/mn/v1/object/urn:uuid:afc58110-b9c1-4cf7-b46c-837bdc930a21
# mv urn\\:uuid\\:afc58110-b9c1-4cf7-b46c-837bdc930a21 vertnet_amphib.gz
# gunzip vertnet_amphib.gz
# sqlite3 amphibians.sqlite

## In SQLite
# sqlite> .separator ','
# sqlite> .import vertnet_amphib amphibians

# After you have a SQLite database, do
# library("dplyr")
# x <- dump_init(path = "~/github/sac/vertnetdumps/amphibians.sqlite")

# use SQL syntax
# tbl(x, sql("SELECT scientificname,title FROM amphibians LIMIT 10"))

# use R syntax
# tab <- x \%>\% dump_tbl()
# tab \%>\%
#  filter(year > 2010) \%>\%
#  select(scientificname, title)
}
}
\references{
\url{http://blog.vertnet.org/post/115875718156/the-data-one-thing-about-vertnet-and-big-data}
}

