% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{whichmin_run}
\alias{whichmin_run}
\title{Running which.min}
\usage{
whichmin_run(x, k = 0L, which = "last", na_rm = TRUE,
  na_pad = FALSE)
}
\arguments{
\item{x}{input logical vector where running whichrun is calculated.}

\item{k}{Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}}

\item{which}{specifies whether \code{"first"} or \code{"last"} index is returned.}

\item{na_rm}{logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed minimum prior to element.}

\item{na_pad}{logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.}
}
\value{
numeric vector of length equals length of \code{x} containing running index of maximum in \code{k}-long window.
}
\description{
Running index of the (first or last) maximum.
}
\examples{
set.seed(11)
x1 <- c(1, 1, 2, 1, 1, 3, 1, 1, 3, 1, 1, 2, 3, 3, 3)
x2 <- c(2, 1, 1, NA, 3, 2, 1, NA, 1, NA, NA, NA, 1, 2, 1)
k  <- c(5, 1, 8, 1, 1, 15, 2, 5, 14, 2, 3, 7, 14, 13, 12)
whichmin_run( x1 , which="first") # running index of minimum
whichmin_run(x1, which="last")
whichmin_run( x2, na_rm = TRUE , which="last" ) # running min-index ommiting NA
whichmin_run(x2 , k=3, na_rm = TRUE, which="first") # running min-index in 3-element window
whichmin_run( x2 , k = k , na_rm = TRUE, which = "last") # running min-index in varying window size
}
