% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{NCA_append_report}
\alias{NCA_append_report}
\title{Append Report Elements}
\usage{
NCA_append_report(state, rpt, rpttype, gen_code_only = FALSE)
}
\arguments{
\item{state}{NCA state from \code{NCA_fetch_state()}}

\item{rpt}{Report with the current content of the report which will be appended to in
this function. For details on the structure see the documentation for
\code{\link[formods:FM_generate_report]{formods::FM_generate_report()}}}

\item{rpttype}{Type of report to generate (supported "xlsx", "pptx", "docx").}

\item{gen_code_only}{Boolean value indicating that only code should be
generated (\code{FALSE}).}
}
\value{
list containing the following elements
\itemize{
\item{isgood:}    Return status of the function.
\item{hasrptele:} Boolean indicator if the module has any reportable elements.
\item{code:}      Code to create report elements.
\item{msgs:}      Messages to be passed back to the user.
\item{rpt:}       Report with any additions passed back to the user.
}
}
\description{
Takes an NCA state object and appends any reportable elements
for the specified report type. On NCA analyses that are in a "good" state
will be reported. Those not in a good state will be ignored.
}
\examples{
# We need a state object to use below
sess_res = NCA_test_mksession()
state = sess_res$state

# here we need an empty report object for tabular data
rpt = list(summary = list(), sheets=list())

# Now we append the report indicating we want
# Excel output:
rpt_res = NCA_append_report(state,
  rpt           = rpt,
  rpttype       = "xlsx",
  gen_code_only = TRUE)

# Shows if report elements are present
rpt_res$hasrptele

# Code chunk to generate report element
cat(paste(rpt_res$code, collapse="\n"))
}
\seealso{
\code{\link[formods:FM_generate_report]{formods::FM_generate_report()}}
}
