% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_pipelines.R
\name{Hasselman_sim_colls}
\alias{Hasselman_sim_colls}
\title{Generate a random population structure and mixture sample, as in
Hasselman \emph{et al.} 2015}
\usage{
Hasselman_sim_colls(RU_starts, RU_vec, size = 100)
}
\arguments{
\item{RU_starts}{a vector delineating the reporting units in \code{RU_vec};
generated by \code{tcf2param_list}}

\item{RU_vec}{a vector of collection indices, grouped by reporting unit;
generated by \code{tcf2param_list}}
}
\value{
\code{Hasselman_sim_colls} returns a list with three elements.
The first two are a rho vector and an omega vector, respectively,
both with alpha parameters = 1.5. The third is a vector of origins for
simulated individuals, sampled from the collections with probabilities = omega
}
\description{
Creates random reporting unit (rho) and collection (omega) proportions, and a
\code{sim_colls} vector for simulation of individual genotypes, based on the methods
used in Hasselman \emph{et al.} (2015)
}
\details{
This function is designed specifically to recreate the simulations in Hasselman
\emph{et al.} (2015), to check for the bias that was observed therein.
Rho (reporting unit proportions) is chosen with alphas of 1.5,
and omega (collection proportions) chosen with the same alpha, then scaled by the
corresponding rho.
}
\keyword{internal}
