// Generated by rstantools.  Do not edit by hand.

/*
    rts2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rts2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rts2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_approxlgcp_nngp_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_approxlgcp_nngp");
    reader.add_event(165, 163, "end", "model_approxlgcp_nngp");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
getAD(const T0__& alpha,
          const T1__& theta,
          const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& x,
          const std::vector<std::vector<int> >& NN,
          const int& mod, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(x));
        current_statement_begin__ = 5;
        int M(0);
        (void) M;  // dummy to suppress unused var warning
        stan::math::fill(M, std::numeric_limits<int>::min());
        stan::math::assign(M,size(NN));
        current_statement_begin__ = 6;
        validate_non_negative_index("A", "M", M);
        validate_non_negative_index("A", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> A(M, n);
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A, DUMMY_VAR__);
        stan::math::assign(A,rep_matrix(0, M, n));
        current_statement_begin__ = 7;
        validate_non_negative_index("D", "n", n);
        Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> D(n);
        stan::math::initialize(D, DUMMY_VAR__);
        stan::math::fill(D, DUMMY_VAR__);
        stan::math::assign(D,rep_row_vector(0, n));
        current_statement_begin__ = 8;
        validate_non_negative_index("AD", "(M + 1)", (M + 1));
        validate_non_negative_index("AD", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> AD((M + 1), n);
        stan::math::initialize(AD, DUMMY_VAR__);
        stan::math::fill(AD, DUMMY_VAR__);
        current_statement_begin__ = 9;
        int idxlim(0);
        (void) idxlim;  // dummy to suppress unused var warning
        stan::math::fill(idxlim, std::numeric_limits<int>::min());
        current_statement_begin__ = 10;
        validate_non_negative_index("smat", "M", M);
        validate_non_negative_index("smat", "M", M);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> smat(M, M);
        stan::math::initialize(smat, DUMMY_VAR__);
        stan::math::fill(smat, DUMMY_VAR__);
        current_statement_begin__ = 11;
        validate_non_negative_index("svec", "M", M);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> svec(M);
        stan::math::initialize(svec, DUMMY_VAR__);
        stan::math::fill(svec, DUMMY_VAR__);
        current_statement_begin__ = 12;
        local_scalar_t__ dist(DUMMY_VAR__);
        (void) dist;  // dummy to suppress unused var warning
        stan::math::initialize(dist, DUMMY_VAR__);
        stan::math::fill(dist, DUMMY_VAR__);
        current_statement_begin__ = 14;
        stan::model::assign(D, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    alpha, 
                    "assigning variable D");
        current_statement_begin__ = 16;
        for (int i = 2; i <= n; ++i) {
            current_statement_begin__ = 17;
            stan::math::assign(idxlim, (logical_lte(i, M) ? (i - 1) : M ));
            current_statement_begin__ = 18;
            stan::model::assign(smat, 
                        stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::nil_index_list())), 
                        rep_matrix(0, idxlim, idxlim), 
                        "assigning variable smat");
            current_statement_begin__ = 19;
            stan::model::assign(svec, 
                        stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::nil_index_list()), 
                        rep_vector(0, idxlim), 
                        "assigning variable svec");
            current_statement_begin__ = 20;
            for (int j = 1; j <= idxlim; ++j) {
                current_statement_begin__ = 21;
                stan::model::assign(smat, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            alpha, 
                            "assigning variable smat");
            }
            current_statement_begin__ = 23;
            if (as_bool(logical_gt(idxlim, 1))) {
                current_statement_begin__ = 24;
                for (int j = 1; j <= (idxlim - 1); ++j) {
                    current_statement_begin__ = 25;
                    for (int k = (j + 1); k <= idxlim; ++k) {
                        current_statement_begin__ = 26;
                        stan::math::assign(dist, stan::math::sqrt((((get_base1(x, get_base1(get_base1(NN, j, "NN", 1), i, "NN", 2), 1, "x", 1) - get_base1(x, get_base1(get_base1(NN, k, "NN", 1), i, "NN", 2), 1, "x", 1)) * (get_base1(x, get_base1(get_base1(NN, j, "NN", 1), i, "NN", 2), 1, "x", 1) - get_base1(x, get_base1(get_base1(NN, k, "NN", 1), i, "NN", 2), 1, "x", 1))) + ((get_base1(x, get_base1(get_base1(NN, j, "NN", 1), i, "NN", 2), 2, "x", 1) - get_base1(x, get_base1(get_base1(NN, k, "NN", 1), i, "NN", 2), 2, "x", 1)) * (get_base1(x, get_base1(get_base1(NN, j, "NN", 1), i, "NN", 2), 2, "x", 1) - get_base1(x, get_base1(get_base1(NN, k, "NN", 1), i, "NN", 2), 2, "x", 1))))));
                        current_statement_begin__ = 28;
                        if (as_bool(logical_eq(mod, 0))) {
                            current_statement_begin__ = 29;
                            stan::model::assign(smat, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                        ((alpha * alpha) * stan::math::exp((-((dist * dist)) / (theta * theta)))), 
                                        "assigning variable smat");
                            current_statement_begin__ = 30;
                            stan::model::assign(smat, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        ((alpha * alpha) * stan::math::exp((-((dist * dist)) / (theta * theta)))), 
                                        "assigning variable smat");
                        } else {
                            current_statement_begin__ = 32;
                            stan::model::assign(smat, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                        ((alpha * alpha) * stan::math::exp((-(dist) / theta))), 
                                        "assigning variable smat");
                            current_statement_begin__ = 33;
                            stan::model::assign(smat, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        ((alpha * alpha) * stan::math::exp((-(dist) / theta))), 
                                        "assigning variable smat");
                        }
                    }
                }
            }
            current_statement_begin__ = 39;
            for (int j = 1; j <= idxlim; ++j) {
                current_statement_begin__ = 40;
                stan::math::assign(dist, stan::math::sqrt((pow((get_base1(x, get_base1(get_base1(NN, j, "NN", 1), i, "NN", 2), 1, "x", 1) - get_base1(x, i, 1, "x", 1)), 2) + pow((get_base1(x, get_base1(get_base1(NN, j, "NN", 1), i, "NN", 2), 2, "x", 1) - get_base1(x, i, 2, "x", 1)), 2))));
                current_statement_begin__ = 41;
                stan::model::assign(svec, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            ((alpha * alpha) * stan::math::exp((-(dist) / theta))), 
                            "assigning variable svec");
            }
            current_statement_begin__ = 43;
            stan::model::assign(A, 
                        stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                        mdivide_left_spd(stan::model::rvalue(smat, stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::nil_index_list())), "smat"), stan::model::rvalue(svec, stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::nil_index_list()), "svec")), 
                        "assigning variable A");
            current_statement_begin__ = 44;
            stan::model::assign(D, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (alpha - dot_product(stan::model::rvalue(A, stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "A"), stan::model::rvalue(svec, stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::nil_index_list()), "svec"))), 
                        "assigning variable D");
        }
        current_statement_begin__ = 47;
        stan::math::assign(AD, append_row(A, D));
        current_statement_begin__ = 49;
        return stan::math::promote_scalar<fun_return_scalar_t__>(AD);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct getAD_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& alpha,
          const T1__& theta,
          const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& x,
          const std::vector<std::vector<int> >& NN,
          const int& mod, std::ostream* pstream__) const {
        return getAD(alpha, theta, x, NN, mod, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
nngp_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& u,
              const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& AD,
              const std::vector<std::vector<int> >& NN, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 54;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,cols(AD));
        current_statement_begin__ = 55;
        int M(0);
        (void) M;  // dummy to suppress unused var warning
        stan::math::fill(M, std::numeric_limits<int>::min());
        stan::math::assign(M,(rows(AD) - 1));
        current_statement_begin__ = 56;
        local_scalar_t__ logdetD(DUMMY_VAR__);
        (void) logdetD;  // dummy to suppress unused var warning
        stan::math::initialize(logdetD, DUMMY_VAR__);
        stan::math::fill(logdetD, DUMMY_VAR__);
        current_statement_begin__ = 57;
        local_scalar_t__ qf(DUMMY_VAR__);
        (void) qf;  // dummy to suppress unused var warning
        stan::math::initialize(qf, DUMMY_VAR__);
        stan::math::fill(qf, DUMMY_VAR__);
        current_statement_begin__ = 58;
        local_scalar_t__ au(DUMMY_VAR__);
        (void) au;  // dummy to suppress unused var warning
        stan::math::initialize(au, DUMMY_VAR__);
        stan::math::fill(au, DUMMY_VAR__);
        current_statement_begin__ = 59;
        local_scalar_t__ ll(DUMMY_VAR__);
        (void) ll;  // dummy to suppress unused var warning
        stan::math::initialize(ll, DUMMY_VAR__);
        stan::math::fill(ll, DUMMY_VAR__);
        current_statement_begin__ = 60;
        int idxlim(0);
        (void) idxlim;  // dummy to suppress unused var warning
        stan::math::fill(idxlim, std::numeric_limits<int>::min());
        current_statement_begin__ = 61;
        validate_non_negative_index("A", "M", M);
        validate_non_negative_index("A", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> A(M, n);
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A, DUMMY_VAR__);
        stan::math::assign(A,stan::model::rvalue(AD, stan::model::cons_list(stan::model::index_min_max(1, M), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "AD"));
        current_statement_begin__ = 62;
        validate_non_negative_index("D", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> D(n);
        stan::math::initialize(D, DUMMY_VAR__);
        stan::math::fill(D, DUMMY_VAR__);
        stan::math::assign(D,transpose(stan::model::rvalue(AD, stan::model::cons_list(stan::model::index_uni((M + 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "AD")));
        current_statement_begin__ = 64;
        stan::math::assign(logdetD, 0);
        current_statement_begin__ = 65;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 66;
            stan::math::assign(logdetD, (logdetD + stan::math::log(get_base1(D, i, "D", 1))));
        }
        current_statement_begin__ = 68;
        stan::math::assign(qf, ((get_base1(u, 1, "u", 1) * get_base1(u, 1, "u", 1)) / get_base1(D, 1, "D", 1)));
        current_statement_begin__ = 69;
        for (int i = 2; i <= n; ++i) {
            current_statement_begin__ = 70;
            stan::math::assign(idxlim, (logical_lte(i, M) ? (i - 1) : M ));
            current_statement_begin__ = 71;
            stan::math::assign(au, (get_base1(u, i, "u", 1) - dot_product(stan::model::rvalue(A, stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "A"), to_vector(stan::model::rvalue(u, stan::model::cons_list(stan::model::index_multi(stan::model::rvalue(NN, stan::model::cons_list(stan::model::index_min_max(1, idxlim), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "NN")), stan::model::nil_index_list()), "u")))));
            current_statement_begin__ = 72;
            stan::math::assign(qf, (qf + ((au * au) / get_base1(D, i, "D", 1))));
        }
        current_statement_begin__ = 74;
        stan::math::assign(ll, (((-(0.5) * logdetD) - (0.5 * qf)) - ((0.5 * n) * stan::math::pi())));
        current_statement_begin__ = 75;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
nngp_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& u,
              const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& AD,
              const std::vector<std::vector<int> >& NN, std::ostream* pstream__) {
    return nngp_lpdf<false>(u,AD,NN, pstream__);
}
struct nngp_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& u,
              const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& AD,
              const std::vector<std::vector<int> >& NN, std::ostream* pstream__) const {
        return nngp_lpdf(u, AD, NN, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_approxlgcp_nngp
  : public stan::model::model_base_crtp<model_approxlgcp_nngp> {
private:
        int D;
        int Q;
        int M;
        int Nsample;
        int nT;
        std::vector<std::vector<int> > NN;
        std::vector<int> y;
        matrix_d x_grid;
        vector_d popdens;
        matrix_d X;
        std::vector<double> prior_lscale;
        std::vector<double> prior_var;
        std::vector<double> prior_linpred_mean;
        std::vector<double> prior_linpred_sd;
        int mod;
        vector_d logpopdens;
public:
    model_approxlgcp_nngp(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_approxlgcp_nngp(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_approxlgcp_nngp_namespace::model_approxlgcp_nngp";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 81;
            context__.validate_dims("data initialization", "D", "int", context__.to_vec());
            D = int(0);
            vals_i__ = context__.vals_i("D");
            pos__ = 0;
            D = vals_i__[pos__++];
            check_greater_or_equal(function__, "D", D, 1);
            current_statement_begin__ = 82;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            check_greater_or_equal(function__, "Q", Q, 1);
            current_statement_begin__ = 83;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 1);
            current_statement_begin__ = 84;
            context__.validate_dims("data initialization", "Nsample", "int", context__.to_vec());
            Nsample = int(0);
            vals_i__ = context__.vals_i("Nsample");
            pos__ = 0;
            Nsample = vals_i__[pos__++];
            check_greater_or_equal(function__, "Nsample", Nsample, 1);
            current_statement_begin__ = 85;
            context__.validate_dims("data initialization", "nT", "int", context__.to_vec());
            nT = int(0);
            vals_i__ = context__.vals_i("nT");
            pos__ = 0;
            nT = vals_i__[pos__++];
            current_statement_begin__ = 86;
            validate_non_negative_index("NN", "M", M);
            validate_non_negative_index("NN", "Nsample", Nsample);
            context__.validate_dims("data initialization", "NN", "int", context__.to_vec(M,Nsample));
            NN = std::vector<std::vector<int> >(M, std::vector<int>(Nsample, int(0)));
            vals_i__ = context__.vals_i("NN");
            pos__ = 0;
            size_t NN_k_0_max__ = M;
            size_t NN_k_1_max__ = Nsample;
            for (size_t k_1__ = 0; k_1__ < NN_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < NN_k_0_max__; ++k_0__) {
                    NN[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 87;
            validate_non_negative_index("y", "(Nsample * nT)", (Nsample * nT));
            context__.validate_dims("data initialization", "y", "int", context__.to_vec((Nsample * nT)));
            y = std::vector<int>((Nsample * nT), int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = (Nsample * nT);
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 88;
            validate_non_negative_index("x_grid", "Nsample", Nsample);
            validate_non_negative_index("x_grid", "D", D);
            context__.validate_dims("data initialization", "x_grid", "matrix_d", context__.to_vec(Nsample,D));
            x_grid = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(Nsample, D);
            vals_r__ = context__.vals_r("x_grid");
            pos__ = 0;
            size_t x_grid_j_2_max__ = D;
            size_t x_grid_j_1_max__ = Nsample;
            for (size_t j_2__ = 0; j_2__ < x_grid_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_grid_j_1_max__; ++j_1__) {
                    x_grid(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 89;
            validate_non_negative_index("popdens", "(Nsample * nT)", (Nsample * nT));
            context__.validate_dims("data initialization", "popdens", "vector_d", context__.to_vec((Nsample * nT)));
            popdens = Eigen::Matrix<double, Eigen::Dynamic, 1>((Nsample * nT));
            vals_r__ = context__.vals_r("popdens");
            pos__ = 0;
            size_t popdens_j_1_max__ = (Nsample * nT);
            for (size_t j_1__ = 0; j_1__ < popdens_j_1_max__; ++j_1__) {
                popdens(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 90;
            validate_non_negative_index("X", "(Nsample * nT)", (Nsample * nT));
            validate_non_negative_index("X", "Q", Q);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec((Nsample * nT),Q));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((Nsample * nT), Q);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = Q;
            size_t X_j_1_max__ = (Nsample * nT);
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 91;
            validate_non_negative_index("prior_lscale", "2", 2);
            context__.validate_dims("data initialization", "prior_lscale", "double", context__.to_vec(2));
            prior_lscale = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("prior_lscale");
            pos__ = 0;
            size_t prior_lscale_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < prior_lscale_k_0_max__; ++k_0__) {
                prior_lscale[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 92;
            validate_non_negative_index("prior_var", "2", 2);
            context__.validate_dims("data initialization", "prior_var", "double", context__.to_vec(2));
            prior_var = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("prior_var");
            pos__ = 0;
            size_t prior_var_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < prior_var_k_0_max__; ++k_0__) {
                prior_var[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 93;
            validate_non_negative_index("prior_linpred_mean", "Q", Q);
            context__.validate_dims("data initialization", "prior_linpred_mean", "double", context__.to_vec(Q));
            prior_linpred_mean = std::vector<double>(Q, double(0));
            vals_r__ = context__.vals_r("prior_linpred_mean");
            pos__ = 0;
            size_t prior_linpred_mean_k_0_max__ = Q;
            for (size_t k_0__ = 0; k_0__ < prior_linpred_mean_k_0_max__; ++k_0__) {
                prior_linpred_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 94;
            validate_non_negative_index("prior_linpred_sd", "Q", Q);
            context__.validate_dims("data initialization", "prior_linpred_sd", "double", context__.to_vec(Q));
            prior_linpred_sd = std::vector<double>(Q, double(0));
            vals_r__ = context__.vals_r("prior_linpred_sd");
            pos__ = 0;
            size_t prior_linpred_sd_k_0_max__ = Q;
            for (size_t k_0__ = 0; k_0__ < prior_linpred_sd_k_0_max__; ++k_0__) {
                prior_linpred_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "mod", "int", context__.to_vec());
            mod = int(0);
            vals_i__ = context__.vals_i("mod");
            pos__ = 0;
            mod = vals_i__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 99;
            validate_non_negative_index("logpopdens", "(Nsample * nT)", (Nsample * nT));
            logpopdens = Eigen::Matrix<double, Eigen::Dynamic, 1>((Nsample * nT));
            stan::math::fill(logpopdens, DUMMY_VAR__);
            stan::math::assign(logpopdens,stan::math::log(popdens));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 103;
            num_params_r__ += 1;
            current_statement_begin__ = 104;
            num_params_r__ += 1;
            current_statement_begin__ = 105;
            validate_non_negative_index("gamma", "Q", Q);
            num_params_r__ += Q;
            current_statement_begin__ = 106;
            num_params_r__ += 1;
            current_statement_begin__ = 107;
            validate_non_negative_index("f_raw", "(Nsample * nT)", (Nsample * nT));
            num_params_r__ += (Nsample * nT);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_approxlgcp_nngp() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 103;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(1e-05, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 104;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(1e-05, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 105;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "Q", Q);
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec(Q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(Q);
        size_t gamma_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 106;
        if (!(context__.contains_r("ar")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ar missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ar");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "ar", "double", context__.to_vec());
        double ar(0);
        ar = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(-(1), 1, ar);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ar: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 107;
        if (!(context__.contains_r("f_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable f_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("f_raw");
        pos__ = 0U;
        validate_non_negative_index("f_raw", "(Nsample * nT)", (Nsample * nT));
        context__.validate_dims("parameter initialization", "f_raw", "vector_d", context__.to_vec((Nsample * nT)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> f_raw((Nsample * nT));
        size_t f_raw_j_1_max__ = (Nsample * nT);
        for (size_t j_1__ = 0; j_1__ < f_raw_j_1_max__; ++j_1__) {
            f_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(f_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable f_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 103;
            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lb_constrain(1e-05, lp__);
            else
                phi = in__.scalar_lb_constrain(1e-05);
            current_statement_begin__ = 104;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(1e-05, lp__);
            else
                sigma = in__.scalar_lb_constrain(1e-05);
            current_statement_begin__ = 105;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_constrain(Q, lp__);
            else
                gamma = in__.vector_constrain(Q);
            current_statement_begin__ = 106;
            local_scalar_t__ ar;
            (void) ar;  // dummy to suppress unused var warning
            if (jacobian__)
                ar = in__.scalar_lub_constrain(-(1), 1, lp__);
            else
                ar = in__.scalar_lub_constrain(-(1), 1);
            current_statement_begin__ = 107;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> f_raw;
            (void) f_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                f_raw = in__.vector_constrain((Nsample * nT), lp__);
            else
                f_raw = in__.vector_constrain((Nsample * nT));
            // transformed parameters
            current_statement_begin__ = 111;
            validate_non_negative_index("AD", "(M + 1)", (M + 1));
            validate_non_negative_index("AD", "Nsample", Nsample);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> AD((M + 1), Nsample);
            stan::math::initialize(AD, DUMMY_VAR__);
            stan::math::fill(AD, DUMMY_VAR__);
            current_statement_begin__ = 112;
            validate_non_negative_index("f", "(Nsample * nT)", (Nsample * nT));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> f((Nsample * nT));
            stan::math::initialize(f, DUMMY_VAR__);
            stan::math::fill(f, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 113;
            stan::math::assign(AD, getAD(sigma, phi, x_grid, NN, mod, pstream__));
            current_statement_begin__ = 114;
            for (int t = 1; t <= nT; ++t) {
                current_statement_begin__ = 115;
                if (as_bool(logical_gt(nT, 1))) {
                    current_statement_begin__ = 116;
                    if (as_bool(logical_eq(t, 1))) {
                        current_statement_begin__ = 117;
                        stan::model::assign(f, 
                                    stan::model::cons_list(stan::model::index_min_max(1, Nsample), stan::model::nil_index_list()), 
                                    multiply((1 / (1 - pow(ar, 2))), stan::model::rvalue(f_raw, stan::model::cons_list(stan::model::index_min_max(1, Nsample), stan::model::nil_index_list()), "f_raw")), 
                                    "assigning variable f");
                    } else {
                        current_statement_begin__ = 119;
                        stan::model::assign(f, 
                                    stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t * Nsample)), stan::model::nil_index_list()), 
                                    stan::model::deep_copy(add(multiply(ar, stan::model::rvalue(f, stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 2)) + 1), ((t - 1) * Nsample)), stan::model::nil_index_list()), "f")), stan::model::rvalue(f_raw, stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t * Nsample)), stan::model::nil_index_list()), "f_raw"))), 
                                    "assigning variable f");
                    }
                } else {
                    current_statement_begin__ = 122;
                    stan::math::assign(f, f_raw);
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 111;
            size_t AD_j_1_max__ = (M + 1);
            size_t AD_j_2_max__ = Nsample;
            for (size_t j_1__ = 0; j_1__ < AD_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < AD_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(AD(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: AD" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable AD: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 112;
            size_t f_j_1_max__ = (Nsample * nT);
            for (size_t j_1__ = 0; j_1__ < f_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(f(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: f" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable f: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 130;
            lp_accum__.add(normal_log<propto__>(phi, get_base1(prior_lscale, 1, "prior_lscale", 1), get_base1(prior_lscale, 2, "prior_lscale", 1)));
            current_statement_begin__ = 131;
            lp_accum__.add(normal_log<propto__>(sigma, get_base1(prior_var, 1, "prior_var", 1), get_base1(prior_var, 2, "prior_var", 1)));
            current_statement_begin__ = 132;
            lp_accum__.add(normal_log<propto__>(ar, 0, 1));
            current_statement_begin__ = 133;
            for (int q = 1; q <= Q; ++q) {
                current_statement_begin__ = 134;
                lp_accum__.add(normal_log<propto__>(get_base1(gamma, q, "gamma", 1), get_base1(prior_linpred_mean, q, "prior_linpred_mean", 1), get_base1(prior_linpred_sd, q, "prior_linpred_sd", 1)));
            }
            current_statement_begin__ = 138;
            for (int t = 1; t <= nT; ++t) {
                current_statement_begin__ = 139;
                if (as_bool(logical_gt(nT, 1))) {
                    current_statement_begin__ = 140;
                    if (as_bool(logical_eq(t, 1))) {
                        current_statement_begin__ = 141;
                        lp_accum__.add(nngp_lpdf<propto__>(stan::model::rvalue(f_raw, stan::model::cons_list(stan::model::index_min_max(1, Nsample), stan::model::nil_index_list()), "f_raw"), AD, NN, pstream__));
                    } else {
                        current_statement_begin__ = 144;
                        lp_accum__.add(nngp_lpdf<propto__>(stan::model::rvalue(f_raw, stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t * Nsample)), stan::model::nil_index_list()), "f_raw"), AD, NN, pstream__));
                    }
                } else {
                    current_statement_begin__ = 148;
                    lp_accum__.add(nngp_lpdf<propto__>(f_raw, AD, NN, pstream__));
                }
            }
            current_statement_begin__ = 154;
            lp_accum__.add(poisson_log_log<propto__>(y, add(add(multiply(X, gamma), logpopdens), f)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi");
        names__.push_back("sigma");
        names__.push_back("gamma");
        names__.push_back("ar");
        names__.push_back("f_raw");
        names__.push_back("AD");
        names__.push_back("f");
        names__.push_back("y_grid_predict");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((Nsample * nT));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((M + 1));
        dims__.push_back(Nsample);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((Nsample * nT));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((Nsample * nT));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_approxlgcp_nngp_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double phi = in__.scalar_lb_constrain(1e-05);
        vars__.push_back(phi);
        double sigma = in__.scalar_lb_constrain(1e-05);
        vars__.push_back(sigma);
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_constrain(Q);
        size_t gamma_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        double ar = in__.scalar_lub_constrain(-(1), 1);
        vars__.push_back(ar);
        Eigen::Matrix<double, Eigen::Dynamic, 1> f_raw = in__.vector_constrain((Nsample * nT));
        size_t f_raw_j_1_max__ = (Nsample * nT);
        for (size_t j_1__ = 0; j_1__ < f_raw_j_1_max__; ++j_1__) {
            vars__.push_back(f_raw(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 111;
            validate_non_negative_index("AD", "(M + 1)", (M + 1));
            validate_non_negative_index("AD", "Nsample", Nsample);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> AD((M + 1), Nsample);
            stan::math::initialize(AD, DUMMY_VAR__);
            stan::math::fill(AD, DUMMY_VAR__);
            current_statement_begin__ = 112;
            validate_non_negative_index("f", "(Nsample * nT)", (Nsample * nT));
            Eigen::Matrix<double, Eigen::Dynamic, 1> f((Nsample * nT));
            stan::math::initialize(f, DUMMY_VAR__);
            stan::math::fill(f, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 113;
            stan::math::assign(AD, getAD(sigma, phi, x_grid, NN, mod, pstream__));
            current_statement_begin__ = 114;
            for (int t = 1; t <= nT; ++t) {
                current_statement_begin__ = 115;
                if (as_bool(logical_gt(nT, 1))) {
                    current_statement_begin__ = 116;
                    if (as_bool(logical_eq(t, 1))) {
                        current_statement_begin__ = 117;
                        stan::model::assign(f, 
                                    stan::model::cons_list(stan::model::index_min_max(1, Nsample), stan::model::nil_index_list()), 
                                    multiply((1 / (1 - pow(ar, 2))), stan::model::rvalue(f_raw, stan::model::cons_list(stan::model::index_min_max(1, Nsample), stan::model::nil_index_list()), "f_raw")), 
                                    "assigning variable f");
                    } else {
                        current_statement_begin__ = 119;
                        stan::model::assign(f, 
                                    stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t * Nsample)), stan::model::nil_index_list()), 
                                    stan::model::deep_copy(add(multiply(ar, stan::model::rvalue(f, stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 2)) + 1), ((t - 1) * Nsample)), stan::model::nil_index_list()), "f")), stan::model::rvalue(f_raw, stan::model::cons_list(stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t * Nsample)), stan::model::nil_index_list()), "f_raw"))), 
                                    "assigning variable f");
                    }
                } else {
                    current_statement_begin__ = 122;
                    stan::math::assign(f, f_raw);
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t AD_j_2_max__ = Nsample;
                size_t AD_j_1_max__ = (M + 1);
                for (size_t j_2__ = 0; j_2__ < AD_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < AD_j_1_max__; ++j_1__) {
                        vars__.push_back(AD(j_1__, j_2__));
                    }
                }
                size_t f_j_1_max__ = (Nsample * nT);
                for (size_t j_1__ = 0; j_1__ < f_j_1_max__; ++j_1__) {
                    vars__.push_back(f(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 158;
            validate_non_negative_index("y_grid_predict", "(Nsample * nT)", (Nsample * nT));
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_grid_predict((Nsample * nT));
            stan::math::initialize(y_grid_predict, DUMMY_VAR__);
            stan::math::fill(y_grid_predict, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 160;
            for (int i = 1; i <= (Nsample * nT); ++i) {
                current_statement_begin__ = 161;
                stan::model::assign(y_grid_predict, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::exp(((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma) + get_base1(logpopdens, i, "logpopdens", 1)) + get_base1(f, i, "f", 1))), 
                            "assigning variable y_grid_predict");
            }
            // validate, write generated quantities
            current_statement_begin__ = 158;
            size_t y_grid_predict_j_1_max__ = (Nsample * nT);
            for (size_t j_1__ = 0; j_1__ < y_grid_predict_j_1_max__; ++j_1__) {
                vars__.push_back(y_grid_predict(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_approxlgcp_nngp";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t gamma_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "ar";
        param_names__.push_back(param_name_stream__.str());
        size_t f_raw_j_1_max__ = (Nsample * nT);
        for (size_t j_1__ = 0; j_1__ < f_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "f_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t AD_j_2_max__ = Nsample;
            size_t AD_j_1_max__ = (M + 1);
            for (size_t j_2__ = 0; j_2__ < AD_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < AD_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "AD" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t f_j_1_max__ = (Nsample * nT);
            for (size_t j_1__ = 0; j_1__ < f_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t y_grid_predict_j_1_max__ = (Nsample * nT);
        for (size_t j_1__ = 0; j_1__ < y_grid_predict_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_grid_predict" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t gamma_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "ar";
        param_names__.push_back(param_name_stream__.str());
        size_t f_raw_j_1_max__ = (Nsample * nT);
        for (size_t j_1__ = 0; j_1__ < f_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "f_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t AD_j_2_max__ = Nsample;
            size_t AD_j_1_max__ = (M + 1);
            for (size_t j_2__ = 0; j_2__ < AD_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < AD_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "AD" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t f_j_1_max__ = (Nsample * nT);
            for (size_t j_1__ = 0; j_1__ < f_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t y_grid_predict_j_1_max__ = (Nsample * nT);
        for (size_t j_1__ = 0; j_1__ < y_grid_predict_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_grid_predict" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_approxlgcp_nngp_namespace::model_approxlgcp_nngp stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
