/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.Iterator;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.vikamine.kernel.util.AttributeValuesIterator;

public class NominalAttributeIterator
implements AttributeValuesIterator {
    private SG sg;
    private Attribute dmAttribute;
    private int next = 0;
    private int valueCount;
    private Iterator iterator;
    private Value val;

    public NominalAttributeIterator(NominalAttribute att, SG sg) {
        this.sg = (SG)sg.clone();
        this.dmAttribute = att;
        this.valueCount = att.getValuesCount();
        this.iterator = att.allValuesIterator();
    }

    @Override
    public int getIterationValueCount() {
        return this.valueCount;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.next;
        this.val = (Value)this.iterator.next();
        return this.val;
    }

    @Override
    public int getCurrentInstancesCount() {
        if (this.next == 0) {
            throw new IllegalStateException("must call next() at least once before");
        }
        this.sg.setTarget(new SelectorTarget(new DefaultSGSelector(this.dmAttribute, this.val)));
        this.sg.createStatistics(this.sg.getStatistics().getOptions());
        return (int)((SGStatisticsBinary)this.sg.getStatistics()).getTp();
    }
}

