/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;

public class PrecisionQF
extends AbstractQFSimpleStatisticBased {
    private static final String ID = "PrecisionQF";
    private static final String NAME = "Precision";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double evaluateNum(double subgroupSize, double subgroupMean, double definedPopulationCount, double populationMean) {
        return Double.NaN;
    }

    @Override
    public double evaluateBin(double subgroupSize, double subgroupPositives, double definedPopulationCount, double populationPositives) {
        double val = subgroupPositives / subgroupSize;
        if (Double.isNaN(val) || Double.isInfinite(val)) {
            return 0.0;
        }
        return val;
    }

    @Override
    public AbstractQFSimpleStatisticBased clone() {
        return new PrecisionQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget() != null && subgroup.getTarget().isBoolean();
    }
}

