/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.constraints;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.constraints.AbstractConstraintStatisticBased;

public class ConstraintMinSubgroupSize
extends AbstractConstraintStatisticBased {
    double minSubgroupSize;
    boolean absolute;

    public ConstraintMinSubgroupSize(double minSubgroupSize, boolean absolute) {
        this.minSubgroupSize = minSubgroupSize;
        this.absolute = absolute;
    }

    public double getMinSubgroupSize() {
        return this.minSubgroupSize;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isSatisfied(SGStatistics statistics) {
        if (this.absolute) {
            return statistics.getSubgroupSize() >= this.minSubgroupSize;
        }
        return statistics.getSubgroupSize() / statistics.getDefinedPopulationCount() >= this.minSubgroupSize;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public void setMinSubgroupSize(double minSubgroupSize) {
        this.minSubgroupSize = minSubgroupSize;
    }

    public double getMinSubgroupSizeAbsolute(SG initialSubgroup) {
        if (this.absolute) {
            return this.minSubgroupSize;
        }
        return this.minSubgroupSize / initialSubgroup.getStatistics().getDefinedPopulationCount();
    }
}

