/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.TripleStoreListener;

public class RDFTripleStore {
    private final Set<RDFStatement> statements = new HashSet<RDFStatement>();
    public static final String ANY_OBJECT = "**ANY_OBJECT**";
    public static final String ANY_PROPERTY = "**ANY_OBJECT**";
    public static List<TripleStoreListener> listeners;

    public RDFTripleStore() {
        listeners = new ArrayList<TripleStoreListener>();
    }

    public void addStatement(RDFStatement s) {
        this.addStatements(Collections.singleton(s));
    }

    public void addStatements(Collection<RDFStatement> s) {
        this.statements.addAll(s);
        this.informListenerStatementsAdded(s);
    }

    public void addListener(TripleStoreListener listener) {
        listeners.add(listener);
    }

    public void removeListener(TripleStoreListener listener) {
        listeners.remove(listener);
    }

    public RDFStatement getFirstMatchingStatement(Object subject, String predicate, Object object) {
        for (RDFStatement s : this.statements) {
            if (!subject.equals("**ANY_OBJECT**") && !s.getSubject().equals(subject) || !predicate.equals("**ANY_OBJECT**") && !predicate.equals(s.getPredicate()) || !object.equals("**ANY_OBJECT**") && !object.equals(s.getObject())) continue;
            return s;
        }
        return null;
    }

    public boolean contains(Object subject, String predicate, Object object) {
        return this.getFirstMatchingStatement(subject, predicate, object) != null;
    }

    public Set<RDFStatement> getStatements() {
        return Collections.unmodifiableSet(this.statements);
    }

    public Set<RDFStatement> getStatements(Object subject, String predicate, Object object) {
        HashSet<RDFStatement> result = new HashSet<RDFStatement>();
        for (RDFStatement s : this.statements) {
            if (!subject.equals("**ANY_OBJECT**") && !s.getSubject().equals(subject) || !predicate.equals("**ANY_OBJECT**") && !predicate.equals(s.getPredicate()) || !object.equals("**ANY_OBJECT**") && !object.equals(s.getObject())) continue;
            result.add(s);
        }
        return result;
    }

    public Set<RDFStatement> getStatementsForFile(String filename) {
        HashSet<RDFStatement> result = new HashSet<RDFStatement>();
        for (RDFStatement s : this.statements) {
            if (!s.hasSource() || !s.getSource().equals(filename)) continue;
            result.add(s);
        }
        return result;
    }

    private void informListenerStatementsAdded(Collection<RDFStatement> s) {
        ArrayList<RDFStatement> reportedStatements = new ArrayList<RDFStatement>();
        for (TripleStoreListener tsl : listeners) {
            Collection<String> supportedTypes = tsl.getSupportedTypes();
            for (RDFStatement aStatement : s) {
                if (!supportedTypes.contains("***ANY***") && !supportedTypes.contains(aStatement.getPredicate())) continue;
                reportedStatements.add(aStatement);
            }
            if (reportedStatements.isEmpty()) continue;
            tsl.statementsAdded(reportedStatements);
            reportedStatements.clear();
        }
    }

    private void informListenerStatementsRemoved(Collection<RDFStatement> s) {
        ArrayList<RDFStatement> reportedStatements = new ArrayList<RDFStatement>();
        for (TripleStoreListener tsl : listeners) {
            Collection<String> supportedTypes = tsl.getSupportedTypes();
            for (RDFStatement aStatement : s) {
                if (!supportedTypes.contains("***ANY***") && !supportedTypes.contains(aStatement.getPredicate())) continue;
                reportedStatements.add(aStatement);
            }
            if (reportedStatements.isEmpty()) continue;
            tsl.statementsRemoved(reportedStatements);
            reportedStatements.clear();
        }
    }

    public void removeStatement(RDFStatement s) {
        this.removeStatements(Collections.singleton(s));
    }

    public void removeStatements(Collection<RDFStatement> s) {
        this.statements.removeAll(s);
        this.informListenerStatementsRemoved(s);
    }

    public String toString() {
        return this.statements.toString();
    }
}

