% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\alias{posterior_predict.stanemax}
\alias{posterior_predict.stanemaxbin}
\alias{posterior_predict_quantile}
\title{Outcome prediction from posterior distribution of parameters}
\usage{
posterior_predict(object, ...)

\method{posterior_predict}{stanemax}(
  object,
  newdata = NULL,
  returnType = c("matrix", "dataframe", "tibble"),
  newDataType = c("raw", "modelframe"),
  ...
)

\method{posterior_predict}{stanemaxbin}(
  object,
  newdata = NULL,
  returnType = c("matrix", "dataframe", "tibble"),
  newDataType = c("raw", "modelframe"),
  ...
)

posterior_predict_quantile(
  object,
  newdata = NULL,
  ci = 0.9,
  pi = 0.9,
  newDataType = c("raw", "modelframe")
)
}
\arguments{
\item{object}{A \code{stanemax} class object}

\item{...}{Additional arguments passed to methods.}

\item{newdata}{An optional data frame that contains columns needed for model to run (exposure and covariates).
If the model does not have any covariate, this can be a numeric vector corresponding to the exposure metric.}

\item{returnType}{An optional string specifying the type of return object.}

\item{newDataType}{An optional string specifying the type of newdata input,
whether in the format of an original data frame or a processed model frame.
Mostly used for internal purposes and users can usually leave at default.}

\item{ci}{Credible interval of the response without residual variability.}

\item{pi}{Prediction interval of the response with residual variability.}
}
\value{
An object that contain predicted response with posterior distribution of parameters.
The default is a matrix containing predicted \code{response} for \code{\link[=stan_emax]{stan_emax()}} and
\code{.epred} for \code{\link[=stan_emax_binary]{stan_emax_binary()}}.
Each row of the matrix is a vector of predictions generated using a single draw of the model parameters from the posterior distribution.

If either \code{dataframe} or \code{tibble} is specified, the function returns a data frame or tibble object in a long format -
each row is a prediction generated using a single draw of the model parameters and a corresponding exposure.

Several types of predictions are generated with this function.

For continuous endpoint model (\code{\link[=stan_emax]{stan_emax()}}),
\itemize{
\item \code{respHat}: prediction without considering residual variability and is intended to provide credible interval of "mean" response.
\item \code{response}: include residual variability in its calculation, therefore the range represents prediction interval of observed response.
}

For binary endpoint model (\code{\link[=stan_emax_binary]{stan_emax_binary()}}),
\itemize{
\item \code{.linpred}: predicted probability on logit scale
\item \code{.epred}: predicted probability on probability scale
}

The return object also contains exposure and parameter values used for calculation.

With \code{\link[=posterior_predict_quantile]{posterior_predict_quantile()}} function, you can obtain quantiles
of \code{respHat} and \code{response} as specified by \code{ci} and \code{pi}.
}
\description{
Compute outcome predictions using posterior samples.
Exposure data for prediction can be either original data used for model fit or new data.
}
\details{
Run \code{vignette("emaxmodel", package = "rstanemax")} to see
how you can use the posterior prediction for plotting estimated Emax curve.
}
