% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title.R
\name{generateAppName}
\alias{generateAppName}
\title{Generate Application Name}
\usage{
generateAppName(appTitle, appPath = NULL, account = NULL, unique = TRUE)
}
\arguments{
\item{appTitle}{A descriptive title for the application.}

\item{appPath}{The path to the application's content, either a directory
or an individual document. Optional.}

\item{account}{The account where the application will be deployed. Optional.}

\item{unique}{Whether to try to generate a unique name.}
}
\value{
Returns a valid short name for the application.
}
\description{
Generate a short name (identifier) for an application given an application
title.
}
\details{
This function modifies the title until it forms a suitable application name.
Suitable application names are 3 - 64 characters long and contain only
alphanumeric characters.

The function is intended to be used to find a name for a new application.
If \code{appPath} and \code{account} are both specified, then the returned
name will also be unique among locally known deployments of the directory
(note that it is not guaranteed to be unique on the server). This behavior
can be disabled by setting \code{unique = FALSE}.
}
\examples{
# Generate a short name for a sample application
generateAppName("My Father's Country", "~/fathers-country", "myacct")

}
