\name{center}
\alias{center}
\alias{center.Q4}
\alias{center.SO3}
\title{Center rotation data}
\usage{
  center(x, S)

  \method{center}{SO3} (x, S)

  \method{center}{Q4} (x, S)
}
\arguments{
  \item{x}{\eqn{n\times p}{n-by-p} matrix where each row
  corresponds to a random rotation in matrix (\eqn{p=9}) or
  quaternion (\eqn{p=4}) form.}

  \item{S}{the rotation or a matrix of \eqn{n\times
  p}{n-by-p} rotations about which to center each row of
  x.}
}
\value{
  The sample centered about S
}
\description{
  This function will take the sample Rs and return the
  sample Rs centered at S.  That is, the ith observation of
  Rs denoted \eqn{R_i}{Ri} is returned as \eqn{S^\top
  R_i}{S'Ri}. If S is the true center then the projected
  mean should be close to the 3-by-3 identity matrix.
}
\examples{
Rs <- ruars(5, rcayley)
cRs <- center(Rs, mean(Rs))
mean(cRs)                      #Close to identity matrix

all.equal(cRs, Rs - mean(Rs))  #TRUE, center and '-' have the same effect
                               #See ?"-.SO3" for more details

center(Rs,Rs)                  #n-Identity matrices: If the second argument is of the same dimension
                               #as Rs then each row is centered around the corresponding
                               #row in the first argument
}

