% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rphenograph.R
\name{find_neighbors}
\alias{find_neighbors}
\title{K Nearest Neighbour Search}
\usage{
find_neighbors(data, k)
}
\arguments{
\item{data}{matrix; input data matrix}

\item{k}{integer; number of nearest neighbours}
}
\value{
a n-by-k matrix of neighbor indices
}
\description{
Uses a kd-tree to find the p number of near neighbours for each point in an input/output dataset.
}
\details{
Use the nn2 function from the RANN package, utilizes the Approximate Near Neighbor (ANN) C++ library,
which can give the exact near neighbours or (as the name suggests) approximate near neighbours
to within a specified error bound. For more information on the ANN library please
visit http://www.cs.umd.edu/~mount/ANN/.
}
\examples{
iris_unique <- unique(iris) # Remove duplicates
data <- as.matrix(iris_unique[,1:4])
neighbors <- find_neighbors(data, k=10)

}
