% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogue.R
\name{catalogue}
\alias{catalogue}
\title{List of stations from UK NRFA}
\usage{
catalogue(bbox = NULL, columnName = NULL, columnValue = NULL,
  minRec = NULL, all = TRUE)
}
\arguments{
\item{bbox}{this is a geographical bounding box (e.g. list(lonMin=-3.82, lonMax=-3.63, latMin=52.43, latMax=52.52))}

\item{columnName}{name of column to filter}

\item{columnValue}{string to search in columnName#'}

\item{minRec}{minimum number of recording years}

\item{all}{if TRUE it returns all the available metadata. If FALSE, it returns only the following columns: id, name, river, hydrometricArea, operator, haName, catchmentArea, altitude, lat, lon.}
}
\value{
data.frame with list of stations and related metadata
}
\description{
This function pulls the list of stations (and related metadata), falling within a given bounding box, from the CEH National River Flow Archive website.
}
\details{
coordinates of bounding box are required in WGS84 (EPSG: 4326). If BB coordinates are missing, the function returns the list corresponding to the maximum extent of the network.

Offline you can browse the cached version running the command \code{data(stationSummary)}
}
\examples{
\dontrun{
  # Retrieve all the stations in the network
  x <- catalogue()

  # Define a bounding box:
  bbox <- list(lonMin=-3.82, lonMax=-3.63, latMin=52.43, latMax=52.52)
  # Get stations within the bounding box
  x <- catalogue(bbox)

  # Get stations based on minimum number of recording years
  x <- catalogue(minRec=30)
}

}
\author{
Claudia Vitolo
}

