% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{Ite}
\alias{Ite}
\title{Ite}
\description{
Create if-then-else expressions in MiniZinc
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{Ite}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.ifs}}{list of if expressions}

\item{\code{.thens}}{list of corresponding then expressions}

\item{\code{.else}}{else expression}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.ifs}}{list of if expressions}

\item{\code{.thens}}{list of corresponding then expressions}

\item{\code{.else}}{else expression}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Ite$new()}}
\item \href{#method-getIfs}{\code{Ite$getIfs()}}
\item \href{#method-getThens}{\code{Ite$getThens()}}
\item \href{#method-setIfsThens}{\code{Ite$setIfsThens()}}
\item \href{#method-getIf}{\code{Ite$getIf()}}
\item \href{#method-setIf}{\code{Ite$setIf()}}
\item \href{#method-getThen}{\code{Ite$getThen()}}
\item \href{#method-setThen}{\code{Ite$setThen()}}
\item \href{#method-getElse}{\code{Ite$getElse()}}
\item \href{#method-setElse}{\code{Ite$setElse()}}
\item \href{#method-c_str}{\code{Ite$c_str()}}
\item \href{#method-getDeleteFlag}{\code{Ite$getDeleteFlag()}}
\item \href{#method-delete}{\code{Ite$delete()}}
\item \href{#method-clone}{\code{Ite$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$new(ifs, thens, Else)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ifs}}{list of if expressions}

\item{\code{thens}}{list of corresponding then expressions}

\item{\code{Else}}{else expression}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIfs"></a>}}
\if{latex}{\out{\hypertarget{method-getIfs}{}}}
\subsection{Method \code{getIfs()}}{
get the if expression list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$getIfs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getThens"></a>}}
\if{latex}{\out{\hypertarget{method-getThens}{}}}
\subsection{Method \code{getThens()}}{
get the then expression list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$getThens()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setIfsThens"></a>}}
\if{latex}{\out{\hypertarget{method-setIfsThens}{}}}
\subsection{Method \code{setIfsThens()}}{
set the if and then expression list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$setIfsThens(ifs, thens)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ifs}}{expression list to be set}

\item{\code{thens}}{expression list to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIf"></a>}}
\if{latex}{\out{\hypertarget{method-getIf}{}}}
\subsection{Method \code{getIf()}}{
get the ith if expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$getIf(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setIf"></a>}}
\if{latex}{\out{\hypertarget{method-setIf}{}}}
\subsection{Method \code{setIf()}}{
set the ith if expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$setIf(i, expIf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}

\item{\code{expIf}}{if expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getThen"></a>}}
\if{latex}{\out{\hypertarget{method-getThen}{}}}
\subsection{Method \code{getThen()}}{
get the ith then expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$getThen(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setThen"></a>}}
\if{latex}{\out{\hypertarget{method-setThen}{}}}
\subsection{Method \code{setThen()}}{
set the ith then expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$setThen(i, expThen)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}

\item{\code{expThen}}{then expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getElse"></a>}}
\if{latex}{\out{\hypertarget{method-getElse}{}}}
\subsection{Method \code{getElse()}}{
get the else expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$getElse()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setElse"></a>}}
\if{latex}{\out{\hypertarget{method-setElse}{}}}
\subsection{Method \code{setElse()}}{
get the else expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$setElse(expElse)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expElse}}{else expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ite$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
