% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{dots_values}
\alias{dots_values}
\title{Evaluate dots with preliminary splicing}
\usage{
dots_values(
  ...,
  .ignore_empty = c("trailing", "none", "all"),
  .preserve_empty = FALSE,
  .homonyms = c("keep", "first", "last", "error"),
  .check_assign = FALSE
)
}
\arguments{
\item{...}{Arguments to evaluate and process splicing operators.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}

\item{.preserve_empty}{Whether to preserve the empty arguments that
were not ignored. If \code{TRUE}, empty arguments are stored with
\code{\link[=missing_arg]{missing_arg()}} values. If \code{FALSE} (the default) an error is
thrown when an empty argument is detected.}

\item{.homonyms}{How to treat arguments with the same name. The
default, \code{"keep"}, preserves these arguments. Set \code{.homonyms} to
\code{"first"} to only keep the first occurrences, to \code{"last"} to keep
the last occurrences, and to \code{"error"} to raise an informative
error and indicate what arguments have duplicated names.}

\item{.check_assign}{Whether to check for \verb{<-} calls passed in
dots. When \code{TRUE} and a \verb{<-} call is detected, a warning is
issued to advise users to use \code{=} if they meant to match a
function parameter, or wrap the \verb{<-} call in braces otherwise.
This ensures assignments are explicit.}
}
\description{
This is a tool for advanced users. It captures dots, processes
unquoting and splicing operators, and evaluates them. Unlike
\code{\link[=dots_list]{dots_list()}}, it does not flatten spliced objects, instead they
are attributed a \code{spliced} class (see \code{\link[=splice]{splice()}}). You can process
spliced objects manually, perhaps with a custom predicate (see
\code{\link[=flatten_if]{flatten_if()}}).
}
\examples{
dots <- dots_values(!!! list(1, 2), 3)
dots

# Flatten the objects marked as spliced:
flatten_if(dots, is_spliced)
}
\keyword{internal}
