% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_args}
\alias{call_args}
\alias{call_args_names}
\title{Extract arguments from a call}
\usage{
call_args(call)

call_args_names(call)
}
\arguments{
\item{call}{Can be a call or a quosure that wraps a call.}
}
\value{
A named list of arguments.
}
\description{
Extract arguments from a call
}
\section{Life cycle}{


In rlang 0.2.0, \code{lang_args()} and \code{lang_args_names()} were
deprecated and renamed to \code{call_args()} and \code{call_args_names()}.
See lifecycle section in \code{\link[=call2]{call2()}} for more about this change.
}

\examples{
call <- quote(f(a, b))

# Subsetting a call returns the arguments converted to a language
# object:
call[-1]

# On the other hand, call_args() returns a regular list that is
# often easier to work with:
str(call_args(call))

# When the arguments are unnamed, a vector of empty strings is
# supplied (rather than NULL):
call_args_names(call)
}
\seealso{
\code{\link[=fn_fmls]{fn_fmls()}} and \code{\link[=fn_fmls_names]{fn_fmls_names()}}
}
