% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo_label}
\alias{quo_label}
\alias{quo_text}
\alias{quo_name}
\title{Format quosures for printing or labelling}
\usage{
quo_label(quo)

quo_text(quo, width = 60L, nlines = Inf)

quo_name(quo)
}
\arguments{
\item{quo}{A quosure or expression.}

\item{width}{Width of each line.}

\item{nlines}{Maximum number of lines to extract.}
}
\description{
\itemize{
\item \code{quo_text()} and \code{quo_label()} are equivalent to \code{\link[=expr_text]{expr_text()}},
\code{\link[=expr_label]{expr_label()}}, etc, but they first squash all quosures with
\code{\link[=quo_squash]{quo_squash()}} so they print more nicely.
\item \code{quo_name()} squashes a quosure and transforms it into a simple
string. It is suitable to give an unnamed quosure a default name,
for instance a column name in a data frame.
}
}
\examples{
# Quosures can contain nested quosures:
quo <- quo(foo(!! quo(bar)))
quo

# quo_squash() unwraps all quosures and returns a raw expression:
quo_squash(quo)

# This is used by quo_text() and quo_label():
quo_text(quo)

# Compare to the unwrapped expression:
expr_text(quo)

# quo_name() is helpful when you need really short labels:
quo_name(quo(sym))
quo_name(quo(!! sym))
}
\seealso{
\code{\link[=expr_label]{expr_label()}}, \code{\link[=f_label]{f_label()}}
}
