% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_dashboard.R, R/simple_dashboard2.R
\name{plot.simple_dashboard}
\alias{plot.simple_dashboard}
\alias{plot.simple_dashboard2}
\title{Plot a simple seasonal adjustment dashboard}
\usage{
\method{plot}{simple_dashboard}(
  x,
  main = "Simple Dashboard",
  subtitle = NULL,
  color_series = c(y = "#F0B400", t = "#1E6C0B", sa = "#155692"),
  reference_date = TRUE,
  ...
)

\method{plot}{simple_dashboard2}(
  x,
  main = "Simple Dashboard with outliers",
  subtitle = NULL,
  color_series = c(y = "#F0B400", t = "#1E6C0B", sa = "#155692"),
  reference_date = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{"sc_dashboard"} object.}

\item{main}{main title.}

\item{subtitle}{subtitle.}

\item{color_series}{Color of the raw time series, the trend and the seasonally adjusted component.}

\item{reference_date}{boolean indicating if the reference date should be printed.}

\item{...}{other parameters (unused).}
}
\description{
Functions to plot a simple dashboard of a seasonal adjustment model.
}
\examples{
data <- window(RJDemetra::ipi_c_eu[, "FR"], start = 2003)
sa_model <- RJDemetra::jx13(data, "RSA5c")
dashboard_data <- simple_dashboard(sa_model)
plot(dashboard_data, main = "Simple dashboard IPI - FR")
dashboard_data2 <- simple_dashboard2(sa_model)
plot(dashboard_data2, main = "Simple dashboard with outliers IPI - FR")
}
\seealso{
\code{\link{simple_dashboard}}.
}
