% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_auth.R
\name{gads_auth_configure}
\alias{gads_auth_configure}
\alias{gads_auth_cache_path}
\alias{gads_open_auth_cache_folder}
\alias{gads_api_key}
\alias{gads_developer_token}
\alias{gads_oauth_app}
\title{Edit and view auth configuration}
\usage{
gads_auth_configure(app, path, api_key, developer_token)

gads_auth_cache_path()

gads_open_auth_cache_folder()

gads_api_key()

gads_developer_token()

gads_oauth_app()
}
\arguments{
\item{app}{OAuth app, in the sense of \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{path}{JSON downloaded from Google Cloud Platform Console, containing a
client id (aka key) and secret, in one of the forms supported for the \code{txt}
argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{api_key}{API key.}

\item{developer_token}{Your Google Ads Developer Token.}
}
\value{
\itemize{
\item \code{gads_auth_configure()}: An object of R6 class
\link[gargle:AuthState-class]{gargle::AuthState}, invisibly.
\item \code{gads_oauth_app()}: the current user-configured
\code{\link[httr:oauth_app]{httr::oauth_app()}}.
\item \code{gads_api_key()}: the current user-configured API key.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=gads_auth]{gads_auth()}} does. \code{gads_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth app, which is used when obtaining a user token.
\item API key. If rgoogleads is de-authorized via \code{\link[=gads_deauth]{gads_deauth()}}, all
requests are sent with an API key in lieu of a token.
See the vignette
\href{https://gargle.r-lib.org/articles/get-api-credentials.html}{How to get your own API credentials}
for more.
If the user does not configure these settings, internal defaults
are used.
\code{gads_oauth_app()} and \code{gads_api_key()} retrieve the
currently configured OAuth app and API key, respectively.
}
}
\examples{
\dontrun{
# see and store the current user-configured OAuth app (probaby `NULL`)
(original_app <- gads_oauth_app())

# see and store the current user-configured API key (probaby `NULL`)
(original_api_key <- gads_api_key())

if (require(httr)) {
  # bring your own app via client id (aka key) and secret
  google_app <- httr::oauth_app(
    "my-awesome-google-api-wrapping-package",
    key = "YOUR_CLIENT_ID_GOES_HERE",
    secret = "YOUR_SECRET_GOES_HERE"
  )
  google_key <- "YOUR_API_KEY"
  gads_auth_configure(app = google_app, api_key = google_key)

  # confirm the changes
  gads_oauth_app()
  gads_api_key()

  # bring your own app via JSON downloaded from Google Developers Console
  # this file has the same structure as the JSON from Google
  gads_auth_configure(path = app_path)

  # confirm the changes
  gads_oauth_app()

  # use own developer token
  gads_auth_configure(developer_token = 'Your developer token')

}

# restore original auth config
gs4_auth_configure(app = original_app, api_key = original_api_key)
}
}
\seealso{
Other auth functions: 
\code{\link{gads_auth}()},
\code{\link{gads_deauth}()}
}
\concept{auth functions}
