% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgt_profile.R
\name{cgt_profile}
\alias{cgt_profile}
\title{Criminal Geographic Targeting Model for Geographic Profiling (Rossmo Formula)}
\usage{
cgt_profile(lat, lon, buffer = NULL, f = NULL, g = NULL, n = NULL)
}
\arguments{
\item{lat}{a vector of latitudes for the crime incident series}

\item{lon}{a vector of latitudes for the crime incident series}

\item{buffer}{the radius for the buffer zone assumed by the distance decay
model.}

\item{f}{decay formula coefficient which changes the steepness of the decay
curve after the buffer radius. If \code{NULL}, the default value for '*f*'
is 1.2 as recommended by Rossmo (1995)}

\item{g}{decay formula coefficient which changes the steepness of the decay
curve before the buffer radius. If \code{NULL}, the default value for '*g*'
is 1.2 as recommended by Rossmo (1995)}

\item{n}{total number of cells within the spatial grid for the jeopardy surface.
If \code{NULL}, the default value for '*n*' is 40,000.}
}
\value{
A data frame of points depicting a spatial grid of the hunting area
    for the given incident locations. Also given are the resultant summed
    values (score) for each map point. A higher resultant score indicates
    a greater the probability that point contains the offender's anchor point.
}
\description{
An implementation of the criminal geographic targeting model
     for serial crime analysis developed by DK Rossmo. This function
     applies Rossmo's distance decay formula to a series of suspected crime
     incidents for geographic profiling and prediction of perpetrator home
     base.
}
\examples{
\dontshow{
data(desalvo)
test <- cgt_profile(desalvo$lat, desalvo$lon, n = 4)
}
\donttest{
#Using provided dataset for the Boston Strangler Incidents:
data(desalvo)
test <- cgt_profile(desalvo$lat, desalvo$lon)
g_map = sp::SpatialPixelsDataFrame(points = test[c("lons", "lats")], data = test)
g_map <- raster::raster(g_map)
# Assign a Coordinate Reference System for the Raster
raster::crs(g_map) <- sp::CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
# Define a Parula Color Pallete for Resultant Jeopardy Surface
library(leaflet) #for mapping the geographic profile
pal <- colorNumeric(pals::parula(200), raster::values(g_map),
    na.color = "transparent")
leaflet() \%>\%
    addTiles() \%>\%
    addProviderTiles('Esri.WorldTopoMap', group = 'Topo') \%>\%
    addAwesomeMarkers(lng = -71.07357, lat = 42.41322, icon =
        awesomeIcons(icon = 'home', markerColor = 'green'), popup = 'Residence') \%>\%
    addRasterImage(g_map, colors = pal, opacity = 0.6) \%>\%
    addLegend(pal = pal, values = raster::values(g_map), title = 'Score') \%>\%
    addCircleMarkers(lng = desalvo$lon, lat = desalvo$lat, radius = 4, opacity = 1,
        fill = 'black', stroke = TRUE, fillOpacity = 0.75, weight = 2,
        fillColor = "red")
}
}
\references{
DK Rossmo (2000). \emph{Geographic profiling. Boca Raton, FL: CRC Press.}

DK Rossmo (1995). \emph{Geographic profiling: Target patterns of serial
    murderers.} Diss. Theses (School of Criminology)/Simon Fraser University.
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{methods}
\keyword{spatial}
