% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_Date.R
\name{rdate_to_eedate}
\alias{rdate_to_eedate}
\title{Pass an R date object to Earth Engine}
\usage{
rdate_to_eedate(date, timestamp = FALSE)
}
\arguments{
\item{date}{R date object}

\item{timestamp}{Logical. If TRUE, return the date in milliseconds
from the Unix Epoch (1970-01-01 00:00:00 UTC). Otherwise return a
EE date object. By default, FALSE.}
}
\value{
\code{rdate_to_eedate} will return either a numeric timestamp or
an ee$Date depending on the \code{timestamp} argument.
}
\description{
Pass an R date object ("Date", "Numeric", "character", "POSIXt",
and "POSIXct") to Google Earth Engine (ee$Date).
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()
rdate_to_eedate('2000-01-01')
rdate_to_eedate(315532800000) # float number
}
}
\seealso{
Other date functions: 
\code{\link{ee_get_date_ic}()},
\code{\link{ee_get_date_img}()},
\code{\link{eedate_to_rdate}()}
}
\concept{date functions}
