% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problems.R
\name{abort_http_problem}
\alias{abort_http_problem}
\alias{abort_status}
\alias{abort_bad_request}
\alias{abort_unauthorized}
\alias{abort_forbidden}
\alias{abort_not_found}
\alias{abort_method_not_allowed}
\alias{abort_not_acceptable}
\alias{abort_conflict}
\alias{abort_gone}
\alias{abort_internal_error}
\alias{handle_problem}
\alias{is_reqres_problem}
\title{Abort request processing with an HTTP problem response}
\usage{
abort_http_problem(
  code,
  detail,
  title = NULL,
  type = NULL,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_status(code, message = status_phrase(code), ..., call = caller_env())

abort_bad_request(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_unauthorized(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_forbidden(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_not_found(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_method_not_allowed(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_not_acceptable(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_conflict(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

abort_gone(detail, instance = NULL, ..., message = detail, call = caller_env())

abort_internal_error(
  detail,
  instance = NULL,
  ...,
  message = detail,
  call = caller_env()
)

handle_problem(response, cnd)

is_reqres_problem(cnd)
}
\arguments{
\item{code}{The HTTP status code to use}

\item{detail}{A string detailing the problem. Make sure the information
given does not pose a security risk}

\item{title}{A human-readable title of the issue. Should not vary from
instance to instance of the specific issue. If \code{NULL} then the status
code title is used}

\item{type}{A URI that uniquely identifies this type of problem. The URI
must resolve to an HTTP document describing the problem in human readable
text. If \code{NULL}, the most recent link to the given status code definition
is used}

\item{instance}{A unique identifier of the specific instance of this
problem that can be used for further debugging. Can be omitted.}

\item{...}{
  Arguments passed on to \code{\link[rlang:cnd]{rlang::error_cnd}}
  \describe{
    \item{\code{class}}{The condition subclass.}
    \item{\code{use_cli_format}}{Whether to use the cli package to format
\code{message}. See \code{\link[rlang:local_use_cli]{local_use_cli()}}.}
    \item{\code{trace}}{A \code{trace} object created by \code{\link[rlang:trace_back]{trace_back()}}.}
    \item{\code{parent}}{A parent condition object.}
  }}

\item{message}{A default message to inform the user about the
condition when it is signalled.}

\item{call}{A function call to be included in the error message.
If an execution environment of a running function, the
corresponding function call is retrieved.}

\item{response}{The Response object associated with the request that created
the condition}

\item{cnd}{The thrown condition}
}
\description{
This set of functions throws a classed error indicating that the request
should be responded to with an HTTP problem according to the spec defined in
\href{https://datatracker.ietf.org/doc/html/rfc9457}{RFC 9457} or a bare response
code. These conditions should be caught and handled by the \code{handle_problem()}
function.
}
