% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_functions.R
\name{futureAreaEstimate}
\alias{futureAreaEstimate}
\title{Future Area Estimate}
\usage{
futureAreaEstimate(A.t1, year.t1, nYears, ARD = NA, PRD = NA, ARC = NA)
}
\arguments{
\item{A.t1}{Area at time t1}

\item{year.t1}{Year of time t1}

\item{nYears}{Number of years since t1 for area prediction}

\item{ARD}{Absolute rate of decline}

\item{PRD}{Proportional rate of decline}

\item{ARC}{Annual rate of change}
}
\value{
A dataframe with the forecast year, and a combination of:
\itemize{
 \item Future area as estimated with absolute rate of decline (ARD)
 \item Future area as estimated with proportional rate of decline (PRD)
 \item Future area as estimated with annual rate of change (ARC)
 }
}
\description{
\code{futureAreaEstimate} is now deprecated, please use
\code{extrapolateEstimate} instead
}
\references{
Bland, L.M., Keith, D.A., Miller, R.M., Murray, N.J. and
  Rodriguez, J.P. (eds.) 2016. Guidelines for the application of IUCN Red
  List of Ecosystems Categories and Criteria, Version 1.0. Gland,
  Switzerland: IUCN. ix + 94pp. Available at the following web site:
  \url{https://iucnrle.org/}
}
\seealso{
Other change_functions: \code{\link{extrapolateEstimate}},
  \code{\link{sequentialExtrapolate}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
