% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RecoSys.R
\name{train}
\alias{train}
\title{Train a Recommender Model}
\arguments{
\item{r}{Object returned by \code{\link{Reco}}()}

\item{outdir}{Directory in which the model file will be
generated. If missing, \code{tempdir()} will be used.}

\item{opts}{Various options and tuning parameters in the model training
procedure. See section \strong{Options and Parameters}
for details.}

\item{verbose}{Whether to show detailed information. Default is \code{TRUE}.}
}
\description{
This method is a member function of class "\code{RecoSys}"
that trains a recommender model. It will create a model file
in the specified directory, containing necessary information for
prediction.
Training data must have already been converted into binary form
through \code{$\link{convert_train}()} before calling this method.

The common usage of this method is
\preformatted{r = Reco()
r$train(outdir, opts, verbose = TRUE)}
}
\section{Options and Parameters}{

The \code{opts} argument is a list that can supply any of the
following parameters:

\describe{
\item{\code{dim}}{Integer, the width of the factorized matrix, i.e.,
                  the number of latent factors. Default is 40.}
\item{\code{niter}}{Integer, the number of iterations. Default is 40.}
\item{\code{nthread}}{Integer, the number of threads for parallel
                      computing. Default is 1.}
\item{\code{cost.p}}{Nonnegative real number, the regularization cost
                     for P. Default is 1.}
\item{\code{cost.q}}{Nonnegative real number, the regularization cost
                     for Q. Default is 1.}
\item{\code{cost.ub}}{Real number, the regularization cost for user bias.
                      Set <0 to disable. Default is -1.}
\item{\code{cost.ib}}{Real number, The regularization cost for item bias.
                      Set <0 to disable. Default is -1.}
\item{\code{gamma}}{Positive real number, the learning rate for parallel
                    SGD. Default is 0.001.}
\item{\code{blocks}}{Integer vector of length 2, the number of blocks for
                     parallel SGD. Default is \code{c(2*nthread,
                     2*nthread)}}
\item{\code{rand_shuffle}}{Logical, whether to enable random shuffle.
                           This should be enabled when data are
                           imbalanced. Default is \code{TRUE}.}
\item{\code{show_tr_rmse}}{Logical, whether to show RMSE on training
                           data. Default is \code{FALSE}.}
\item{\code{show_obj}}{Logical, whether to show the objective value.
                       This option may slow down the training procedure.
                       Default is \code{FALSE}.}
\item{\code{use_avg}}{Logical, whether to use training data average.
                      Default is \code{FALSE}.}
}
}
\examples{
set.seed(123) # this is a randomized algorithm
trainset = system.file("dat", "smalltrain.txt", package = "recosystem")
testset = system.file("dat", "smalltest.txt", package = "recosystem")
r = Reco()
r$convert_train(trainset)
r$convert_test(testset)
r$train(opts = list(dim = 80, cost.p = 0.01, cost.q = 0.01))
print(r)
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
\references{
LIBMF: A Matrix-factorization Library for Recommender Systems.
\url{http://www.csie.ntu.edu.tw/~cjlin/libmf/}

Y. Zhuang, W.-S. Chin, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
Technical report 2014.
}
\seealso{
\code{\link{convert}}, \code{\link{output}}, \code{\link{predict}}
}

