% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.recipe}
\alias{tidy.recipe}
\title{Tidy the Result of a Recipe}
\usage{
\method{tidy}{recipe}(x, number = NA, ...)
}
\arguments{
\item{x}{A \code{recipe} object (trained or otherwise).}

\item{number}{An integer or \code{NA}. If missing, the return
value is a list of the operation in the recipe. If a number is
given, a \code{tidy} method is executed for that operation in the
recipe (if it exists).}

\item{...}{Not currently used.}
}
\value{
A tibble with columns that would vary depending on what
\code{tidy} method is executed. When \code{x} is \code{NA}, a
tibble with columns \code{number} (the operation iteration),
\code{operation} (either "step" or "check"),
\code{type} (the method, e.g. "nzv", "center"), a logical
column called \code{trained} for whether the operation has been
estimated using \code{prep}, and a logical for \code{skip}.
}
\description{
\code{tidy} will return a data frame that contains information
regarding a recipe or operation within the recipe (when a \code{tidy}
method for the operation exists).
}
\examples{
data(okc)

okc_rec <- recipe(~ ., data = okc) \%>\%
  step_other(all_nominal(), threshold = 0.05) \%>\%
  step_date(date, features = "dow") \%>\%
  step_center(all_numeric()) \%>\%
  step_dummy(all_nominal()) \%>\%
  check_cols(starts_with("date"), age, height)

tidy(okc_rec)

tidy(okc_rec, number = 2)
tidy(okc_rec, number = 3)

okc_rec_trained <- prep(okc_rec, training = okc)

tidy(okc_rec_trained)
tidy(okc_rec_trained, number = 3)
}
